/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.notificationq.dispatching;

import org.joda.time.DateTime;
import org.killbill.CreatorName;
import org.killbill.notificationq.NotificationQueueDispatcher;
import org.killbill.notificationq.NotificationQueueException;
import org.killbill.notificationq.api.NotificationEvent;
import org.killbill.notificationq.api.NotificationQueueService;
import org.killbill.notificationq.dao.NotificationEventModelDao;
import org.killbill.queue.api.PersistentQueueEntryLifecycleState;
import org.killbill.queue.dispatching.CallableCallbackBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationCallableCallback
extends CallableCallbackBase<NotificationEvent, NotificationEventModelDao> {
    private static final Logger log = LoggerFactory.getLogger(NotificationCallableCallback.class);
    private final NotificationQueueDispatcher parent;

    public NotificationCallableCallback(NotificationQueueDispatcher parent) {
        super(parent.getDao(), parent.getClock(), parent.getConfig(), parent.getObjectMapper());
        this.parent = parent;
    }

    @Override
    public void dispatch(NotificationEvent event, NotificationEventModelDao modelDao) throws NotificationQueueException {
        NotificationQueueService.NotificationQueueHandler handler = this.parent.getHandlerForActiveQueue(modelDao.getQueueName());
        if (handler == null) {
            throw new IllegalStateException(String.format("Cannot find handler for notification: queue = %s, record_id = %s", modelDao.getQueueName(), modelDao.getRecordId()));
        }
        this.parent.handleNotificationWithMetrics(handler, modelDao, event);
    }

    @Override
    public NotificationEventModelDao buildEntry(NotificationEventModelDao modelDao, DateTime now, PersistentQueueEntryLifecycleState newState, long newErrorCount) {
        return new NotificationEventModelDao(modelDao, CreatorName.get(), now, newState, (Long)newErrorCount);
    }
}

