/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.bus.api;

import org.killbill.queue.api.PersistentQueueConfig;
import org.skife.config.Config;
import org.skife.config.Default;
import org.skife.config.Description;
import org.skife.config.TimeSpan;

public abstract class PersistentBusConfig
implements PersistentQueueConfig {
    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.inMemory"})
    @Default(value="false")
    @Description(value="Whether the bus should be an in memory bus")
    public abstract boolean isInMemory();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.max.failure.retry"})
    @Default(value="3")
    @Description(value="Number of retries for a given event when an exception occurs")
    public abstract int getMaxFailureRetries();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.inflight.min"})
    @Default(value="1")
    @Description(value="Min number of bus events to fetch from the database at once (only valid in 'STICKY_EVENTS')")
    public abstract int getMinInFlightEntries();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.inflight.max"})
    @Default(value="100")
    @Description(value="Max number of bus events to fetch from the database at once (only valid in 'STICKY_EVENTS')")
    public abstract int getMaxInFlightEntries();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.claimed"})
    @Default(value="10")
    @Description(value="Number of bus events to fetch from the database at once (only valid in 'polling mode')")
    public abstract int getMaxEntriesClaimed();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.queue.mode"})
    @Default(value="STICKY_EVENTS")
    @Description(value="How entries are put in the queue")
    public abstract PersistentQueueConfig.PersistentQueueMode getPersistentQueueMode();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.claim.time"})
    @Default(value="5m")
    @Description(value="Claim time")
    public abstract TimeSpan getClaimedTime();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.sleep"})
    @Default(value="3000")
    @Description(value="Time in milliseconds to sleep between runs (only valid in STICKY_POLLING, POLLING)")
    public abstract long getPollingSleepTimeMs();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.off"})
    @Default(value="false")
    @Description(value="Whether to turn off the persistent bus")
    public abstract boolean isProcessingOff();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.nbThreads"})
    @Default(value="30")
    @Description(value="Max number of dispatch threads to use")
    public abstract int geMaxDispatchThreads();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.lifecycle.dispatch.nbThreads"})
    @Default(value="1")
    @Description(value="Max number of lifecycle dispatch threads to use")
    public abstract int geNbLifecycleDispatchThreads();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.lifecycle.complete.nbThreads"})
    @Default(value="2")
    @Description(value="Max number of lifecycle complete threads to use")
    public abstract int geNbLifecycleCompleteThreads();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.queue.capacity"})
    @Default(value="30000")
    @Description(value="Size of the inflight queue (only valid in STICKY_EVENTS mode)")
    public abstract int getEventQueueCapacity();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.tableName"})
    @Default(value="bus_events")
    @Description(value="Bus events table name")
    public abstract String getTableName();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.historyTableName"})
    @Default(value="bus_events_history")
    @Description(value="Bus events history table name")
    public abstract String getHistoryTableName();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.reapThreshold"})
    @Default(value="10m")
    @Description(value="Time span when the bus event must be re-dispatched")
    public abstract TimeSpan getReapThreshold();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.maxReDispatchCount"})
    @Default(value="10")
    @Description(value="Max number of bus events to be re-dispatched at a time")
    public abstract int getMaxReDispatchCount();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.reapSchedule"})
    @Default(value="3m")
    @Description(value="Reaper schedule period")
    public abstract TimeSpan getReapSchedule();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.shutdownTimeout"})
    @Default(value="15s")
    @Description(value="Shutdown sequence timeout")
    public abstract TimeSpan getShutdownTimeout();
}

