/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.eventbus.EventBusException;
import com.google.common.eventbus.TestSetupEventBusThatThrowsException;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class TestMultiThreadedEventBusThatThrowsException
extends TestSetupEventBusThatThrowsException {
    @BeforeSuite(groups={"fast"})
    public void setUpSuite() throws Exception {
        this.busSetup();
    }

    @Test(groups={"fast"}, threadPoolSize=25, invocationCount=100, description="Check that postWithException is thread safe")
    public void testThrowFirstExceptionMultithreaded() throws Exception {
        int n = rand.nextInt(10000) + 1;
        String subscriberMarker = n % 2 == 0 ? "A" : "B";
        TestSetupEventBusThatThrowsException.MyEvent event = new TestSetupEventBusThatThrowsException.MyEvent(UUID.randomUUID(), subscriberMarker);
        try {
            this.eventBus.postWithException((Object)event);
            Assert.fail();
        }
        catch (EventBusException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvocationTargetException));
            Assert.assertTrue((boolean)(e.getCause().getCause() instanceof RuntimeException));
            Assert.assertEquals((String)e.getCause().getCause().getMessage(), (String)TestSetupEventBusThatThrowsException.Subscriber.exceptionMarker(subscriberMarker));
        }
        if ("A".equals(subscriberMarker)) {
            this.checkEventsSeen(this.subscriberA, new TestSetupEventBusThatThrowsException.MyEvent[0]);
            this.checkEventsSeen(this.subscriberB, event);
        } else {
            this.checkEventsSeen(this.subscriberA, event);
            this.checkEventsSeen(this.subscriberB, new TestSetupEventBusThatThrowsException.MyEvent[0]);
        }
    }
}

