/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.eventbus.EventBusThatThrowsException;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.testng.Assert;

class TestSetupEventBusThatThrowsException {
    static final Random rand = new Random();
    EventBusThatThrowsException eventBus;
    Subscriber subscriberA;
    Subscriber subscriberB;

    TestSetupEventBusThatThrowsException() {
    }

    void busSetup() {
        this.eventBus = new EventBusThatThrowsException("testing");
        this.subscriberA = new SubscriberA();
        this.eventBus.register((Object)this.subscriberA);
        this.subscriberB = new SubscriberB();
        this.eventBus.register((Object)this.subscriberB);
    }

    void checkEventsSeen(Subscriber subscriber, MyEvent ... events) {
        Collection myEvents = subscriber.events.removeAll((Object)Thread.currentThread().getId());
        Assert.assertEquals((int)myEvents.size(), (int)events.length);
        int i = 0;
        for (MyEvent myEvent : myEvents) {
            Assert.assertTrue((myEvent == events[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    protected static final class MyEvent {
        private final UUID id;
        private final Set<String> exceptionThrowerIds;

        MyEvent(UUID id, String ... exceptionThrowerIds) {
            this.id = id;
            this.exceptionThrowerIds = ImmutableSet.copyOf((Object[])exceptionThrowerIds);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyEvent myEvent = (MyEvent)o;
            return this.id != null ? this.id.equals(myEvent.id) : myEvent.id == null;
        }

        public int hashCode() {
            return this.id != null ? this.id.hashCode() : 0;
        }
    }

    protected static final class SubscriberB
    extends Subscriber {
        protected SubscriberB() {
        }

        @Subscribe
        public void onEvent(MyEvent event) {
            this.maybeThrow(event, "B");
            this.events.put((Object)Thread.currentThread().getId(), (Object)event);
        }
    }

    protected static final class SubscriberA
    extends Subscriber {
        protected SubscriberA() {
        }

        @Subscribe
        public void onEvent(MyEvent event) {
            this.maybeThrow(event, "A");
            this.events.put((Object)Thread.currentThread().getId(), (Object)event);
        }
    }

    static abstract class Subscriber {
        final Multimap<Long, MyEvent> events = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());

        Subscriber() {
        }

        static String exceptionMarker(String id) {
            return String.format("%s-%s", Thread.currentThread().getId(), id);
        }

        void maybeThrow(MyEvent event, String id) {
            if (event.exceptionThrowerIds.contains(id)) {
                throw new RuntimeException(Subscriber.exceptionMarker(id));
            }
        }
    }
}

