/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.queue;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.killbill.CreatorName;
import org.killbill.TestSetup;
import org.killbill.bus.api.PersistentBusConfig;
import org.killbill.bus.dao.BusEventModelDao;
import org.killbill.bus.dao.PersistentBusSqlDao;
import org.killbill.clock.Clock;
import org.killbill.queue.DBBackedQueueWithInflightQueue;
import org.killbill.queue.api.PersistentQueueConfig;
import org.killbill.queue.dao.EventEntryModelDao;
import org.skife.config.TimeSpan;
import org.skife.jdbi.v2.IDBI;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestDBBackedQueueWithInflightQ
extends TestSetup {
    private DBBackedQueueWithInflightQueue<BusEventModelDao> queue;
    private PersistentBusSqlDao sqlDao;

    @Override
    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        super.beforeClass();
        this.sqlDao = (PersistentBusSqlDao)this.getDBI().onDemand(PersistentBusSqlDao.class);
    }

    @Override
    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        List ready = this.sqlDao.getReadyEntries(this.clock.getUTCNow().toDate(), 100, null, "bus_events");
        Assert.assertEquals((int)ready.size(), (int)0);
    }

    @Test(groups={"slow"})
    public void testInflightQWithExistingEntries() {
        int NB_ENTRIES = 2345;
        PersistentBusConfig config = this.createConfig();
        this.queue = new DBBackedQueueWithInflightQueue((Clock)this.clock, (IDBI)this.dbi, PersistentBusSqlDao.class, (PersistentQueueConfig)config, "testInflightQWithExistingEntries", this.metricRegistry, this.databaseTransactionNotificationApi);
        for (int i = 0; i < 2345; ++i) {
            BusEventModelDao input = this.createEntry(new Long(i + 5));
            this.sqlDao.insertEntry((EventEntryModelDao)input, config.getTableName());
        }
        long readyEntries = this.queue.getNbReadyEntries();
        Assert.assertEquals((long)readyEntries, (long)2345L);
        this.queue.initialize();
        Assert.assertEquals((int)this.queue.getInflightQSize(), (int)2345);
    }

    private BusEventModelDao createEntry(Long searchKey1, String owner) {
        String json = "json";
        return new BusEventModelDao(owner, this.clock.getUTCNow(), String.class.getName(), "json", UUID.randomUUID(), searchKey1, Long.valueOf(1L));
    }

    private BusEventModelDao createEntry(Long searchKey1) {
        return this.createEntry(searchKey1, CreatorName.get());
    }

    private PersistentBusConfig createConfig() {
        return new PersistentBusConfig(){

            public boolean isInMemory() {
                return false;
            }

            public int getMaxFailureRetries() {
                return 0;
            }

            public int getMinInFlightEntries() {
                return 1;
            }

            public int getMaxInFlightEntries() {
                return 100;
            }

            public int getMaxEntriesClaimed() {
                return 100;
            }

            public PersistentQueueConfig.PersistentQueueMode getPersistentQueueMode() {
                return PersistentQueueConfig.PersistentQueueMode.STICKY_EVENTS;
            }

            public TimeSpan getClaimedTime() {
                return new TimeSpan("5m");
            }

            public long getPollingSleepTimeMs() {
                return -1L;
            }

            public boolean isProcessingOff() {
                return false;
            }

            public int geMaxDispatchThreads() {
                return 1;
            }

            public int geNbLifecycleDispatchThreads() {
                return 1;
            }

            public int geNbLifecycleCompleteThreads() {
                return 1;
            }

            public int getEventQueueCapacity() {
                return -1;
            }

            public String getTableName() {
                return "bus_events";
            }

            public String getHistoryTableName() {
                return "bus_events_history";
            }

            public TimeSpan getReapThreshold() {
                return new TimeSpan(5L, TimeUnit.MINUTES);
            }

            public int getMaxReDispatchCount() {
                return 10;
            }

            public TimeSpan getReapSchedule() {
                return new TimeSpan(3L, TimeUnit.MINUTES);
            }

            public TimeSpan getShutdownTimeout() {
                return new TimeSpan(5L, TimeUnit.SECONDS);
            }
        };
    }
}

