/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.queue.dispatching;

import com.fasterxml.jackson.databind.ObjectReader;
import org.killbill.queue.api.QueueEvent;
import org.killbill.queue.dao.EventEntryModelDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventEntryDeserializer {
    private static final Logger log = LoggerFactory.getLogger(EventEntryDeserializer.class);

    public static <E extends QueueEvent, M extends EventEntryModelDao> E deserialize(M modelDao, ObjectReader objectReader) {
        try {
            Class<?> claz = Class.forName(modelDao.getClassName());
            return (E)((QueueEvent)objectReader.readValue(modelDao.getEventJson(), claz));
        }
        catch (Exception e) {
            log.error("Failed to deserialize json object {} for class {}", new Object[]{modelDao.getEventJson(), modelDao.getClassName(), e});
            return null;
        }
    }
}

