/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.bus;

import java.util.concurrent.TimeUnit;
import org.killbill.bus.InMemoryPersistentBus;
import org.killbill.bus.TestEventBusBase;
import org.killbill.bus.api.PersistentBus;
import org.killbill.bus.api.PersistentBusConfig;
import org.killbill.queue.api.PersistentQueueConfig;
import org.skife.config.TimeSpan;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestInMemoryEventBus {
    private TestEventBusBase testEventBusBase;
    private PersistentBus busService;

    @BeforeClass(groups={"fast"})
    public void beforeClass() throws Exception {
        this.busService = new InMemoryPersistentBus(new PersistentBusConfig(){

            public boolean isInMemory() {
                return false;
            }

            public int getMaxFailureRetries() {
                return 0;
            }

            public int getMinInFlightEntries() {
                return 1;
            }

            public int getMaxInFlightEntries() {
                return 1;
            }

            public int getMaxEntriesClaimed() {
                return 0;
            }

            public PersistentQueueConfig.PersistentQueueMode getPersistentQueueMode() {
                return PersistentQueueConfig.PersistentQueueMode.POLLING;
            }

            public TimeSpan getClaimedTime() {
                return null;
            }

            public long getPollingSleepTimeMs() {
                return 0L;
            }

            public boolean isProcessingOff() {
                return false;
            }

            public int geMaxDispatchThreads() {
                return 0;
            }

            public int geNbLifecycleDispatchThreads() {
                return 1;
            }

            public int geNbLifecycleCompleteThreads() {
                return 1;
            }

            public int getEventQueueCapacity() {
                return 0;
            }

            public String getTableName() {
                return "test";
            }

            public String getHistoryTableName() {
                return null;
            }

            public TimeSpan getReapThreshold() {
                return new TimeSpan(5L, TimeUnit.MINUTES);
            }

            public int getMaxReDispatchCount() {
                return 10;
            }

            public TimeSpan getReapSchedule() {
                return new TimeSpan(3L, TimeUnit.MINUTES);
            }

            public TimeSpan getShutdownTimeout() {
                return new TimeSpan(5L, TimeUnit.SECONDS);
            }
        });
        this.testEventBusBase = new TestEventBusBase(this.busService);
    }

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() throws Exception {
        this.busService.startQueue();
    }

    @AfterMethod(groups={"fast"})
    public void afterMethod() {
        this.busService.stopQueue();
    }

    @Test(groups={"fast"})
    public void testSimple() {
        this.testEventBusBase.testSimple();
    }

    @Test(groups={"fast"})
    public void testDifferentType() {
        this.testEventBusBase.testDifferentType();
    }

    @Test(groups={"fast"})
    public void testSimpleWithExceptionAndRetrySuccess() {
        this.testEventBusBase.testSimpleWithExceptionAndRetrySuccess();
    }

    @Test(groups={"fast"})
    public void testSimpleWithExceptionAndFail() {
        this.testEventBusBase.testSimpleWithExceptionAndFail();
    }
}

