/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.bus;

import org.killbill.TestSetup;
import org.killbill.bus.DefaultPersistentBus;
import org.killbill.bus.TestEventBusBase;
import org.killbill.bus.api.PersistentBus;
import org.killbill.clock.Clock;
import org.killbill.commons.utils.collect.Iterables;
import org.skife.jdbi.v2.IDBI;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestPersistentEventBus
extends TestSetup {
    private TestEventBusBase testEventBusBase;
    private PersistentBus busService;

    @Override
    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        super.beforeClass();
    }

    @Override
    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        this.busService = new DefaultPersistentBus((IDBI)this.getDBI(), (Clock)this.clock, this.getPersistentBusConfig(), this.metricRegistry, this.databaseTransactionNotificationApi);
        this.testEventBusBase = new TestEventBusBase(this.busService);
        this.busService.startQueue();
    }

    @AfterMethod(groups={"slow"})
    public void afterMethod() throws Exception {
        this.busService.stopQueue();
    }

    @Test(groups={"slow"})
    public void testSimple() {
        this.assertNoInProcessingEvent();
        this.testEventBusBase.testSimple();
        this.assertNoInProcessingEvent();
    }

    @Test(groups={"slow"})
    public void testSimpleWithExceptionAndRetrySuccess() {
        this.assertNoInProcessingEvent();
        this.testEventBusBase.testSimpleWithExceptionAndRetrySuccess();
        this.assertNoInProcessingEvent();
    }

    @Test(groups={"slow"})
    public void testSimpleWithExceptionAndFail() {
        this.assertNoInProcessingEvent();
        this.testEventBusBase.testSimpleWithExceptionAndFail();
        this.assertNoInProcessingEvent();
    }

    private void assertNoInProcessingEvent() {
        Assert.assertEquals((int)Iterables.size((Iterable)this.busService.getInProcessingBusEvents()), (int)0);
        Assert.assertEquals((long)this.busService.getNbReadyEntries(this.clock.getUTCNow()), (long)0L);
    }
}

