/*
 * Decompiled with CFR 0.152.
 */
package org.killbill;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.killbill.CreatorName;
import org.killbill.bus.api.PersistentBusConfig;
import org.killbill.clock.ClockMock;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.embeddeddb.h2.H2EmbeddedDB;
import org.killbill.commons.embeddeddb.mysql.MySQLEmbeddedDB;
import org.killbill.commons.embeddeddb.postgresql.PostgreSQLEmbeddedDB;
import org.killbill.commons.jdbi.notification.DatabaseTransactionNotificationApi;
import org.killbill.commons.jdbi.transaction.NotificationTransactionHandler;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.commons.metrics.impl.NoOpMetricRegistry;
import org.killbill.commons.utils.io.ByteStreams;
import org.killbill.commons.utils.io.Resources;
import org.killbill.notificationq.api.NotificationQueueConfig;
import org.killbill.queue.InTransaction;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;
import org.skife.config.SimplePropertyConfigSource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.tweak.TransactionHandler;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public class TestSetup {
    private static final String TEST_DB_PROPERTY_PREFIX = "org.killbill.billing.dbi.test.";
    protected static final Long SEARCH_KEY_1 = 1L;
    protected static final Long SEARCH_KEY_2 = 2L;
    protected EmbeddedDB embeddedDB;
    protected DBI dbi;
    protected PersistentBusConfig persistentBusConfig;
    protected NotificationQueueConfig notificationQueueConfig;
    protected ClockMock clock;
    protected final MetricRegistry metricRegistry = new NoOpMetricRegistry();
    protected DatabaseTransactionNotificationApi databaseTransactionNotificationApi;

    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        TestSetup.loadSystemPropertiesFromClasspath("/org/killbill/queue/queue.properties");
        this.clock = new ClockMock();
        this.embeddedDB = "true".equals(System.getProperty("org.killbill.billing.dbi.test.h2")) ? new H2EmbeddedDB("killbillq", "killbillq", "killbillq") : ("true".equals(System.getProperty("org.killbill.billing.dbi.test.postgresql")) ? new PostgreSQLEmbeddedDB("killbillq", "killbillq") : new MySQLEmbeddedDB("killbillq", "killbillq", "killbillq"));
        this.embeddedDB.initialize();
        this.embeddedDB.start();
        if (this.embeddedDB.getDBEngine() == EmbeddedDB.DBEngine.POSTGRESQL) {
            this.embeddedDB.executeScript("CREATE DOMAIN datetime AS timestamp without time zone;CREATE OR REPLACE FUNCTION last_insert_id() RETURNS BIGINT AS $$\n    DECLARE\n        result BIGINT;\n    BEGIN\n        SELECT lastval() INTO result;\n        RETURN result;\n    EXCEPTION WHEN OTHERS THEN\n        SELECT NULL INTO result;\n        RETURN result;\n    END;\n$$ LANGUAGE plpgsql VOLATILE;");
        }
        String ddl = TestSetup.toString(Resources.getResource((String)"org/killbill/queue/ddl.sql").openStream());
        this.embeddedDB.executeScript(ddl);
        this.embeddedDB.refreshTableNames();
        this.databaseTransactionNotificationApi = new DatabaseTransactionNotificationApi();
        this.dbi = new DBI(this.embeddedDB.getDataSource());
        InTransaction.setupDBI((DBI)this.dbi);
        this.dbi.setTransactionHandler((TransactionHandler)new NotificationTransactionHandler(this.databaseTransactionNotificationApi));
        SimplePropertyConfigSource configSource = new SimplePropertyConfigSource(System.getProperties());
        this.persistentBusConfig = (PersistentBusConfig)new ConfigurationObjectFactory((ConfigSource)configSource).buildWithReplacements(PersistentBusConfig.class, Map.of("instanceName", "main"));
        this.notificationQueueConfig = (NotificationQueueConfig)new ConfigurationObjectFactory((ConfigSource)configSource).buildWithReplacements(NotificationQueueConfig.class, Map.of("instanceName", "main"));
    }

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        CreatorName.reset();
        System.clearProperty("org.killbill.queue.creator.name");
        this.embeddedDB.cleanupAllTables();
        this.clock.resetDeltaFromReality();
    }

    @AfterClass(groups={"slow"})
    public void afterClass() throws Exception {
        this.embeddedDB.stop();
    }

    public static String toString(InputStream inputStream) throws IOException {
        try {
            String string = new String(ByteStreams.toByteArray((InputStream)inputStream), StandardCharsets.UTF_8);
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public DBI getDBI() {
        return this.dbi;
    }

    public PersistentBusConfig getPersistentBusConfig() {
        return this.persistentBusConfig;
    }

    public NotificationQueueConfig getNotificationQueueConfig() {
        return this.notificationQueueConfig;
    }

    private static void loadSystemPropertiesFromClasspath(String resource) {
        URL url = TestSetup.class.getResource(resource);
        Assert.assertNotNull((Object)url);
        try {
            System.getProperties().load(url.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

