/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.notificationq;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.CreatorName;
import org.killbill.clock.Clock;
import org.killbill.notificationq.MockNotificationQueueService;
import org.killbill.notificationq.NotificationQueueDispatcher;
import org.killbill.notificationq.api.NotificationEvent;
import org.killbill.notificationq.api.NotificationEventWithMetadata;
import org.killbill.notificationq.api.NotificationQueue;
import org.killbill.notificationq.api.NotificationQueueService;
import org.killbill.notificationq.dao.NotificationEventModelDao;
import org.killbill.queue.api.PersistentQueueEntryLifecycleState;
import org.killbill.queue.dao.EventEntryModelDao;
import org.killbill.queue.dispatching.EventEntryDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockNotificationQueue
implements NotificationQueue {
    private final Logger log = LoggerFactory.getLogger((String)"MockNotificationQueue");
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final String hostname;
    private final TreeSet<NotificationEventModelDao> notifications;
    private final Clock clock;
    private final String svcName;
    private final String queueName;
    private final NotificationQueueService.NotificationQueueHandler handler;
    private final MockNotificationQueueService queueService;
    private final AtomicLong recordIds;
    private volatile boolean isStarted;

    public MockNotificationQueue(Clock clock, String svcName, String queueName, NotificationQueueService.NotificationQueueHandler handler, MockNotificationQueueService mockNotificationQueueService) {
        this.svcName = svcName;
        this.queueName = queueName;
        this.handler = handler;
        this.clock = clock;
        this.hostname = CreatorName.get();
        this.queueService = mockNotificationQueueService;
        this.recordIds = new AtomicLong();
        this.notifications = new TreeSet<NotificationEventModelDao>(new Comparator<NotificationEventModelDao>(){

            @Override
            public int compare(NotificationEventModelDao o1, NotificationEventModelDao o2) {
                if (o1.getEffectiveDate().equals((Object)o2.getEffectiveDate())) {
                    return o1.getRecordId().compareTo(o2.getRecordId());
                }
                return o1.getEffectiveDate().compareTo((ReadableInstant)o2.getEffectiveDate());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordFutureNotification(DateTime futureNotificationTime, NotificationEvent eventJson, UUID userToken, Long searchKey1, Long searchKey2) throws IOException {
        String json = objectMapper.writeValueAsString((Object)eventJson);
        Long searchKey2WithNull = Objects.requireNonNullElse(searchKey2, 0L);
        NotificationEventModelDao notification = new NotificationEventModelDao(this.recordIds.incrementAndGet(), "MockQueue", this.hostname, this.clock.getUTCNow(), null, PersistentQueueEntryLifecycleState.AVAILABLE, eventJson.getClass().getName(), json, Long.valueOf(0L), userToken, searchKey1, searchKey2WithNull, UUID.randomUUID(), futureNotificationTime, "MockQueue");
        TreeSet<NotificationEventModelDao> treeSet = this.notifications;
        synchronized (treeSet) {
            this.notifications.add(notification);
        }
    }

    public void recordFutureNotificationFromTransaction(Connection connection, DateTime futureNotificationTime, NotificationEvent eventJson, UUID userToken, Long searchKey1, Long searchKey2) throws IOException {
        this.recordFutureNotification(futureNotificationTime, eventJson, userToken, searchKey1, searchKey2);
    }

    public void updateFutureNotification(Long recordId, NotificationEvent eventJson, Long searchKey1, Long searchKey2) throws IOException {
    }

    public void updateFutureNotificationFromTransaction(Connection connection, Long recordId, NotificationEvent eventJson, Long searchKey1, Long searchKey2) throws IOException {
    }

    public <T extends NotificationEvent> List<NotificationEventWithMetadata<T>> getFutureNotificationForSearchKeys(Long searchKey1, Long searchKey2) {
        return null;
    }

    public <T extends NotificationEvent> List<NotificationEventWithMetadata<T>> getFutureNotificationFromTransactionForSearchKeys(Long searchKey1, Long searchKey2, Connection connection) {
        return null;
    }

    public <T extends NotificationEvent> List<NotificationEventWithMetadata<T>> getFutureNotificationForSearchKey2(DateTime maxEffectiveDate, Long searchKey2) {
        return null;
    }

    public <T extends NotificationEvent> List<NotificationEventWithMetadata<T>> getFutureNotificationFromTransactionForSearchKey2(DateTime maxEffectiveDate, Long searchKey2, Connection connection) {
        return null;
    }

    public <T extends NotificationEvent> List<NotificationEventWithMetadata<T>> getInProcessingNotifications() {
        return null;
    }

    public <T extends NotificationEvent> List<NotificationEventWithMetadata<T>> getFutureOrInProcessingNotificationForSearchKeys(Long searchKey1, Long searchKey2) {
        return null;
    }

    public <T extends NotificationEvent> List<NotificationEventWithMetadata<T>> getFutureOrInProcessingNotificationFromTransactionForSearchKeys(Long searchKey1, Long searchKey2, Connection connection) {
        return null;
    }

    public <T extends NotificationEvent> List<NotificationEventWithMetadata<T>> getFutureOrInProcessingNotificationForSearchKey2(DateTime maxEffectiveDate, Long searchKey2) {
        return null;
    }

    public <T extends NotificationEvent> List<NotificationEventWithMetadata<T>> getFutureOrInProcessingNotificationFromTransactionForSearchKey2(DateTime maxEffectiveDate, Long searchKey2, Connection connection) {
        return null;
    }

    public <T extends NotificationEvent> List<NotificationEventWithMetadata<T>> getHistoricalNotificationForSearchKeys(Long searchKey1, Long searchKey2) {
        return null;
    }

    public <T extends NotificationEvent> List<NotificationEventWithMetadata<T>> getHistoricalNotificationForSearchKey2(DateTime minEffectiveDate, Long searchKey2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends NotificationEvent> List<NotificationEventWithMetadata<T>> getFutureNotificationsInternal(Class<T> type, Long searchKey1, Connection connection) {
        ArrayList<NotificationEventWithMetadata<T>> result = new ArrayList<NotificationEventWithMetadata<T>>();
        TreeSet<NotificationEventModelDao> treeSet = this.notifications;
        synchronized (treeSet) {
            for (NotificationEventModelDao notification : this.notifications) {
                if (!notification.getSearchKey1().equals(searchKey1) || !type.getName().equals(notification.getClassName()) || !notification.getEffectiveDate().isAfter((ReadableInstant)this.clock.getUTCNow())) continue;
                NotificationEvent event = (NotificationEvent)EventEntryDeserializer.deserialize((EventEntryModelDao)notification, (ObjectReader)objectMapper.reader());
                NotificationEventWithMetadata foo = new NotificationEventWithMetadata(notification.getRecordId(), notification.getUserToken(), notification.getCreatedDate(), notification.getSearchKey1(), notification.getSearchKey2(), event, notification.getFutureUserToken(), notification.getEffectiveDate(), notification.getQueueName());
                result.add(foo);
            }
        }
        return result;
    }

    public long getNbReadyEntries(DateTime maxEffectiveDate) {
        return 0L;
    }

    public void removeNotification(Long recordId) {
        this.removeNotificationFromTransaction(null, recordId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationFromTransaction(Connection connection, Long recordId) {
        TreeSet<NotificationEventModelDao> treeSet = this.notifications;
        synchronized (treeSet) {
            for (NotificationEventModelDao cur : this.notifications) {
                if (!cur.getRecordId().equals(recordId)) continue;
                this.notifications.remove(cur);
                break;
            }
        }
    }

    public void removeFutureNotificationsForSearchKeys(Long searchKey1, Long searchKey2) {
    }

    public String getFullQName() {
        return NotificationQueueDispatcher.getCompositeName((String)this.svcName, (String)this.queueName);
    }

    public String getServiceName() {
        return this.svcName;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public NotificationQueueService.NotificationQueueHandler getHandler() {
        return this.handler;
    }

    public boolean initQueue() {
        return true;
    }

    public boolean startQueue() {
        this.isStarted = true;
        this.queueService.startQueue();
        return true;
    }

    public boolean stopQueue() {
        this.isStarted = false;
        return this.queueService.stopQueue();
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NotificationEventModelDao> getReadyNotifications() {
        ArrayList<NotificationEventModelDao> readyNotifications = new ArrayList<NotificationEventModelDao>();
        TreeSet<NotificationEventModelDao> treeSet = this.notifications;
        synchronized (treeSet) {
            for (NotificationEventModelDao cur : this.notifications) {
                if (!cur.getEffectiveDate().isBefore((ReadableInstant)this.clock.getUTCNow()) || !cur.isAvailableForProcessing(this.clock.getUTCNow())) continue;
                this.log.info("MockNotificationQ getReadyNotifications found notification: NOW = " + this.clock.getUTCNow() + " recordId = " + cur.getRecordId() + ", state = " + cur.getProcessingState() + ", effectiveDate = " + cur.getEffectiveDate());
                readyNotifications.add(cur);
            }
        }
        return readyNotifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markProcessedNotifications(List<NotificationEventModelDao> toBeremoved, List<NotificationEventModelDao> toBeAdded) {
        TreeSet<NotificationEventModelDao> treeSet = this.notifications;
        synchronized (treeSet) {
            this.notifications.removeAll(toBeremoved);
            this.notifications.addAll(toBeAdded);
        }
    }
}

