/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.notificationq;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.notificationq.NotificationQueueDispatcher;
import org.killbill.notificationq.api.NotificationQueue;
import org.killbill.notificationq.api.NotificationQueueConfig;
import org.killbill.notificationq.api.NotificationQueueService;
import org.skife.jdbi.v2.IDBI;

public abstract class NotificationQueueServiceBase
extends NotificationQueueDispatcher
implements NotificationQueueService {
    public NotificationQueueServiceBase(Clock clock, NotificationQueueConfig config, IDBI dbi, MetricRegistry metricRegistry) {
        super(clock, config, dbi, metricRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotificationQueue createNotificationQueue(String svcName, String queueName, NotificationQueueService.NotificationQueueHandler handler) throws NotificationQueueService.NotificationQueueAlreadyExists {
        NotificationQueue result;
        if (svcName == null || queueName == null || handler == null) {
            throw new RuntimeException("Need to specify all parameters");
        }
        String compositeName = NotificationQueueServiceBase.getCompositeName(svcName, queueName);
        Map map = this.queues;
        synchronized (map) {
            result = (NotificationQueue)this.queues.get(compositeName);
            if (result != null) {
                throw new NotificationQueueService.NotificationQueueAlreadyExists(String.format("Queue for svc %s and name %s already exist", svcName, queueName));
            }
            result = this.createNotificationQueueInternal(svcName, queueName, handler);
            this.queues.put(compositeName, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotificationQueue getNotificationQueue(String svcName, String queueName) throws NotificationQueueService.NoSuchNotificationQueue {
        NotificationQueue result;
        String compositeName = NotificationQueueServiceBase.getCompositeName(svcName, queueName);
        Map map = this.queues;
        synchronized (map) {
            result = (NotificationQueue)this.queues.get(compositeName);
            if (result == null) {
                throw new NotificationQueueService.NoSuchNotificationQueue(String.format("Queue for svc %s and name %s does not exist", svcName, queueName));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNotificationQueue(String svcName, String queueName) throws NotificationQueueService.NoSuchNotificationQueue {
        String compositeName = NotificationQueueServiceBase.getCompositeName(svcName, queueName);
        Map map = this.queues;
        synchronized (map) {
            NotificationQueue result = (NotificationQueue)this.queues.get(compositeName);
            if (result == null) {
                throw new NotificationQueueService.NoSuchNotificationQueue(String.format("Queue for svc %s and name %s does not exist", svcName, queueName));
            }
            this.queues.remove(compositeName);
        }
    }

    @Override
    public List<NotificationQueue> getNotificationQueues() {
        return new ArrayList<NotificationQueue>(this.queues.values());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NotificationQueueServiceBase");
        sb.append("{queues=").append(this.queues);
        sb.append('}');
        return sb.toString();
    }

    protected abstract NotificationQueue createNotificationQueueInternal(String var1, String var2, NotificationQueueService.NotificationQueueHandler var3);
}

