/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.notificationq.api;

import org.killbill.queue.api.PersistentQueueConfig;
import org.skife.config.Config;
import org.skife.config.Default;
import org.skife.config.Description;
import org.skife.config.TimeSpan;

public abstract class NotificationQueueConfig
implements PersistentQueueConfig {
    @Override
    @Config(value={"org.killbill.notificationq.${instanceName}.inMemory"})
    @Default(value="false")
    @Description(value="Set to false, not available for NotificationQueue")
    public abstract boolean isInMemory();

    @Override
    @Config(value={"org.killbill.notificationq.${instanceName}.max.failure.retry"})
    @Default(value="3")
    @Description(value="Number retry for a given event when an exception occurs")
    public abstract int getMaxFailureRetries();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.inflight.min"})
    @Default(value="-1")
    @Description(value="Min number of bus events to fetch from the database at once (only valid in 'STICKY_EVENTS')")
    public abstract int getMinInFlightEntries();

    @Override
    @Config(value={"org.killbill.persistent.bus.${instanceName}.inflight.max"})
    @Default(value="-1")
    @Description(value="Max number of bus events to fetch from the database at once (only valid in 'STICKY_EVENTS')")
    public abstract int getMaxInFlightEntries();

    @Override
    @Config(value={"org.killbill.notificationq.${instanceName}.claimed"})
    @Default(value="10")
    @Description(value="Number of notifications to fetch at once")
    public abstract int getMaxEntriesClaimed();

    @Override
    @Config(value={"org.killbill.notificationq.${instanceName}.queue.mode"})
    @Default(value="STICKY_POLLING")
    @Description(value="How entries are put in the queue")
    public abstract PersistentQueueConfig.PersistentQueueMode getPersistentQueueMode();

    @Override
    @Config(value={"org.killbill.notificationq.${instanceName}.claim.time"})
    @Default(value="5m")
    @Description(value="Claim time")
    public abstract TimeSpan getClaimedTime();

    @Override
    @Config(value={"org.killbill.notificationq.${instanceName}.sleep"})
    @Default(value="3000")
    @Description(value="Time in milliseconds to sleep between runs")
    public abstract long getPollingSleepTimeMs();

    @Override
    @Config(value={"org.killbill.notificationq.${instanceName}.notification.off"})
    @Default(value="false")
    @Description(value="Whether to turn off the notification queue")
    public abstract boolean isProcessingOff();

    @Override
    @Config(value={"org.killbill.notificationq.${instanceName}.notification.nbThreads"})
    @Default(value="10")
    @Description(value="Number of threads to use")
    public abstract int geMaxDispatchThreads();

    @Override
    @Config(value={"org.killbill.notificationq.${instanceName}.lifecycle.dispatch.nbThreads"})
    @Default(value="1")
    @Description(value="Max number of lifecycle dispatch threads to use")
    public abstract int geNbLifecycleDispatchThreads();

    @Override
    @Config(value={"org.killbill.notificationq.${instanceName}.lifecycle.complete.nbThreads"})
    @Default(value="2")
    @Description(value="Max number of lifecycle complete threads to use")
    public abstract int geNbLifecycleCompleteThreads();

    @Override
    @Config(value={"org.killbill.notificationq.${instanceName}.queue.capacity"})
    @Default(value="100")
    @Description(value="Capacity for the worker queue")
    public abstract int getEventQueueCapacity();

    @Override
    @Config(value={"org.killbill.notificationq.${instanceName}.tableName"})
    @Default(value="notifications")
    @Description(value="Notifications table name")
    public abstract String getTableName();

    @Override
    @Config(value={"org.killbill.notificationq.${instanceName}.historyTableName"})
    @Default(value="notifications_history")
    @Description(value="Notifications history table name")
    public abstract String getHistoryTableName();

    @Override
    @Config(value={"org.killbill.notificationq.${instanceName}.reapThreshold"})
    @Default(value="10m")
    @Description(value="Time span when a notification must be re-dispatched")
    public abstract TimeSpan getReapThreshold();

    @Override
    @Config(value={"org.killbill.notificationq.${instanceName}.maxReDispatchCount"})
    @Default(value="10")
    @Description(value="Max number of notification to be re-dispatched at a time")
    public abstract int getMaxReDispatchCount();

    @Override
    @Config(value={"org.killbill.notificationq.${instanceName}.reapSchedule"})
    @Default(value="3m")
    @Description(value="Reaper schedule period")
    public abstract TimeSpan getReapSchedule();

    @Override
    @Config(value={"org.killbill.notificationq.${instanceName}.shutdownTimeout"})
    @Default(value="15s")
    @Description(value="Shutdown sequence timeout")
    public abstract TimeSpan getShutdownTimeout();
}

