/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.queue.dispatching;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingRejectionExecutionHandler
implements RejectedExecutionHandler {
    private final Logger logger = LoggerFactory.getLogger(BlockingRejectionExecutionHandler.class);

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        try {
            if (!executor.isShutdown()) {
                this.logger.info("BlockingRejectionExecutionHandler will block request");
                executor.getQueue().put(r);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RejectedExecutionException("Executor was interrupted while the task was waiting to put on work queue", e);
        }
    }
}

