/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.queue.dispatching;

import com.fasterxml.jackson.databind.ObjectReader;
import org.joda.time.DateTime;
import org.killbill.clock.Clock;
import org.killbill.queue.DBBackedQueue;
import org.killbill.queue.api.PersistentQueueConfig;
import org.killbill.queue.api.PersistentQueueEntryLifecycleState;
import org.killbill.queue.api.QueueEvent;
import org.killbill.queue.dao.EventEntryModelDao;
import org.killbill.queue.dispatching.CallableCallback;
import org.killbill.queue.dispatching.EventEntryDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CallableCallbackBase<E extends QueueEvent, M extends EventEntryModelDao>
implements CallableCallback<E, M> {
    private static final Logger log = LoggerFactory.getLogger(CallableCallbackBase.class);
    private final DBBackedQueue<M> dao;
    private final Clock clock;
    private final PersistentQueueConfig config;
    private final ObjectReader objectReader;

    public CallableCallbackBase(DBBackedQueue<M> dao, Clock clock, PersistentQueueConfig config, ObjectReader objectReader) {
        this.dao = dao;
        this.clock = clock;
        this.config = config;
        this.objectReader = objectReader;
    }

    @Override
    public E deserialize(M modelDao) {
        return EventEntryDeserializer.deserialize(modelDao, this.objectReader);
    }

    @Override
    public void moveCompletedOrFailedEvents(Iterable<M> entries) {
        this.dao.moveEntriesToHistory(entries);
    }

    @Override
    public void updateRetriedEvents(M updatedEntry) {
        this.dao.updateOnError(updatedEntry);
    }

    @Override
    public abstract void dispatch(E var1, M var2) throws Exception;

    @Override
    public abstract M buildEntry(M var1, DateTime var2, PersistentQueueEntryLifecycleState var3, long var4);
}

