/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.queue.retry;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.bus.api.BusEvent;
import org.killbill.clock.Clock;
import org.killbill.commons.utils.TypeToken;
import org.killbill.commons.utils.cache.Cache;
import org.killbill.commons.utils.cache.DefaultSynchronizedCache;
import org.killbill.notificationq.api.NotificationEvent;
import org.killbill.notificationq.api.NotificationQueueService;
import org.killbill.queue.retry.RetryableHandler;
import org.killbill.queue.retry.RetryableService;
import org.killbill.queue.retry.SubscriberNotificationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableSubscriber
extends RetryableHandler {
    private static final Logger log = LoggerFactory.getLogger(RetryableSubscriber.class);

    public RetryableSubscriber(Clock clock, RetryableService retryableService, NotificationQueueService.NotificationQueueHandler handlerDelegate) {
        super(clock, retryableService, handlerDelegate);
    }

    public void handleEvent(BusEvent event) {
        this.handleReadyNotification(new SubscriberNotificationEvent(event, event.getClass()), this.clock.getUTCNow(), event.getUserToken(), event.getSearchKey1(), event.getSearchKey2());
    }

    public static final class SubscriberQueueHandler
    implements NotificationQueueService.NotificationQueueHandler {
        private static final Cache<Class<?>, Set<Class<?>>> FLATTEN_HIERARCHY_CACHE = new DefaultSynchronizedCache(key -> new LinkedHashSet(TypeToken.getRawTypes((Class)key)));
        private final Map<Class<?>, SubscriberAction<? extends BusEvent>> actions = new HashMap();

        public <B extends BusEvent> void subscribe(Class<B> busEventClass, SubscriberAction<B> action) {
            this.actions.put(busEventClass, action);
        }

        @Override
        public void handleReadyNotification(NotificationEvent eventJson, DateTime eventDateTime, UUID userToken, Long searchKey1, Long searchKey2) {
            if (!(eventJson instanceof SubscriberNotificationEvent)) {
                log.error("SubscriberQueueHandler received an unexpected event className='{}'", eventJson.getClass());
            } else {
                BusEvent busEvent = ((SubscriberNotificationEvent)eventJson).getBusEvent();
                Set eventTypes = (Set)FLATTEN_HIERARCHY_CACHE.get(busEvent.getClass());
                for (Class eventType : eventTypes) {
                    SubscriberAction<? extends BusEvent> next = this.actions.get(eventType);
                    if (next == null) continue;
                    next.run(busEvent);
                }
            }
        }
    }

    public static interface SubscriberAction<T extends BusEvent> {
        public void run(T var1);
    }
}

