/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.notificationq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.api.Histogram;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.notificationq.NotificationQueueException;
import org.killbill.notificationq.NotificationReaper;
import org.killbill.notificationq.api.NotificationEvent;
import org.killbill.notificationq.api.NotificationQueue;
import org.killbill.notificationq.api.NotificationQueueConfig;
import org.killbill.notificationq.api.NotificationQueueService;
import org.killbill.notificationq.dao.NotificationEventModelDao;
import org.killbill.notificationq.dao.NotificationSqlDao;
import org.killbill.notificationq.dispatching.NotificationCallableCallback;
import org.killbill.queue.DBBackedQueue;
import org.killbill.queue.DBBackedQueueWithPolling;
import org.killbill.queue.DefaultQueueLifecycle;
import org.killbill.queue.dao.EventEntryModelDao;
import org.killbill.queue.dispatching.BlockingRejectionExecutionHandler;
import org.killbill.queue.dispatching.Dispatcher;
import org.skife.jdbi.v2.IDBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationQueueDispatcher
extends DefaultQueueLifecycle {
    protected static final Logger log = LoggerFactory.getLogger(NotificationQueueDispatcher.class);
    public static final int CLAIM_TIME_MS = 300000;
    private final AtomicLong nbProcessedEvents;
    protected final NotificationQueueConfig config;
    protected final Clock clock;
    protected final Map<String, NotificationQueue> queues;
    protected final DBBackedQueue<NotificationEventModelDao> dao;
    protected final MetricRegistry metricRegistry;
    private final Map<String, Histogram> perQueueProcessingTime;
    private final Dispatcher<NotificationEvent, NotificationEventModelDao> dispatcher;
    private final AtomicBoolean isInitialized;
    private volatile boolean isStarted;
    private volatile int activeQueues;
    private final NotificationCallableCallback notificationCallableCallback;
    private final NotificationReaper reaper;

    NotificationQueueDispatcher(Clock clock, final NotificationQueueConfig config, IDBI dbi, MetricRegistry metricRegistry) {
        super(config.getTableName(), config, metricRegistry);
        ThreadFactory notificationQThreadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread th = new Thread(r);
                th.setName(config.getTableName() + "-th");
                th.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        log.error("Uncaught exception for thread " + t.getName(), e);
                    }
                });
                return th;
            }
        };
        this.clock = clock;
        this.config = config;
        this.nbProcessedEvents = new AtomicLong();
        this.dao = new DBBackedQueueWithPolling<NotificationEventModelDao>(clock, dbi, NotificationSqlDao.class, config, config.getTableName(), metricRegistry);
        this.queues = new TreeMap<String, NotificationQueue>();
        this.perQueueProcessingTime = new HashMap<String, Histogram>();
        this.metricRegistry = metricRegistry;
        this.isInitialized = new AtomicBoolean(false);
        this.isStarted = false;
        this.activeQueues = 0;
        this.reaper = new NotificationReaper(this.dao, config, clock);
        this.notificationCallableCallback = new NotificationCallableCallback(this);
        this.dispatcher = new Dispatcher<NotificationEvent, NotificationEventModelDao>(1, config, 10L, TimeUnit.MINUTES, config.getShutdownTimeout().getPeriod(), config.getShutdownTimeout().getUnit(), new LinkedBlockingQueue<Runnable>(config.getEventQueueCapacity()), notificationQThreadFactory, new BlockingRejectionExecutionHandler(), clock, this.notificationCallableCallback, this);
    }

    @Override
    public boolean initQueue() {
        if (this.isInitialized.compareAndSet(false, true)) {
            this.dao.initialize();
            this.dispatcher.start();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startQueue() {
        if (!this.isInitialized.get()) {
            this.initQueue();
        }
        Map<String, NotificationQueue> map = this.queues;
        synchronized (map) {
            ++this.activeQueues;
            if (!this.isStarted) {
                this.reaper.start();
                super.startQueue();
                this.isStarted = true;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopQueue() {
        Map<String, NotificationQueue> map = this.queues;
        synchronized (map) {
            if (this.activeQueues == 0) {
                return true;
            }
            --this.activeQueues;
            if (this.activeQueues == 0) {
                this.isInitialized.set(false);
                boolean terminated = true;
                if (!this.reaper.stop()) {
                    terminated = false;
                }
                if (!super.stopLifecycleDispatcher()) {
                    terminated = false;
                }
                if (!this.dispatcher.stopDispatcher()) {
                    terminated = false;
                }
                if (!super.stopLifecycleCompletion()) {
                    terminated = false;
                }
                this.dao.close();
                this.isStarted = false;
                return terminated;
            }
            return false;
        }
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public DefaultQueueLifecycle.DispatchResultMetrics doDispatchEvents() {
        List<NotificationEventModelDao> notifications = this.getReadyNotifications();
        if (notifications.isEmpty()) {
            return new DefaultQueueLifecycle.DispatchResultMetrics(0, -1L);
        }
        log.debug("Notifications from {} to process: {}", (Object)this.config.getTableName(), notifications);
        for (NotificationEventModelDao cur : notifications) {
            this.dispatcher.dispatch(cur);
        }
        return new DefaultQueueLifecycle.DispatchResultMetrics(notifications.size(), -1L);
    }

    @Override
    public void doProcessCompletedEvents(Iterable<? extends EventEntryModelDao> completed) {
        this.notificationCallableCallback.moveCompletedOrFailedEvents(completed);
    }

    @Override
    public void doProcessRetriedEvents(Iterable<? extends EventEntryModelDao> retried) {
        for (NotificationEventModelDao notificationEventModelDao : retried) {
            this.notificationCallableCallback.updateRetriedEvents(notificationEventModelDao);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotificationWithMetrics(NotificationQueueService.NotificationQueueHandler handler, NotificationEventModelDao notification, NotificationEvent key) throws NotificationQueueException {
        String[] parts = notification.getQueueName().split(":");
        String metricName = parts[0].substring(0, 3) + "-" + parts[1] + "-ProcessingTime";
        Histogram perQueueHistogramProcessingTime = this.perQueueProcessingTime.get(notification.getQueueName());
        if (perQueueHistogramProcessingTime == null) {
            Map<String, Histogram> map = this.perQueueProcessingTime;
            synchronized (map) {
                if (!this.perQueueProcessingTime.containsKey(notification.getQueueName())) {
                    this.perQueueProcessingTime.put(notification.getQueueName(), this.metricRegistry.histogram(String.format("%s.%s", NotificationQueueDispatcher.class.getName(), metricName)));
                }
                perQueueHistogramProcessingTime = this.perQueueProcessingTime.get(notification.getQueueName());
            }
        }
        long beforeProcessing = System.nanoTime();
        try {
            handler.handleReadyNotification(key, notification.getEffectiveDate(), notification.getFutureUserToken(), notification.getSearchKey1(), notification.getSearchKey2());
        }
        catch (RuntimeException e) {
            throw new NotificationQueueException(e);
        }
        finally {
            this.nbProcessedEvents.incrementAndGet();
            perQueueHistogramProcessingTime.update(System.nanoTime() - beforeProcessing);
        }
    }

    public NotificationQueueService.NotificationQueueHandler getHandlerForActiveQueue(String compositeName) {
        NotificationQueue queue = this.queues.get(compositeName);
        if (queue == null || !queue.isStarted()) {
            return null;
        }
        return queue.getHandler();
    }

    private List<NotificationEventModelDao> getReadyNotifications() {
        DBBackedQueue.ReadyEntriesWithMetrics<NotificationEventModelDao> result = this.dao.getReadyEntries();
        List<NotificationEventModelDao> input = result.getEntries();
        ArrayList<NotificationEventModelDao> claimedNotifications = new ArrayList<NotificationEventModelDao>();
        for (NotificationEventModelDao cur : input) {
            NotificationQueue queue = this.queues.get(cur.getQueueName());
            if (queue == null || !queue.isStarted()) continue;
            claimedNotifications.add(cur);
        }
        return claimedNotifications;
    }

    public static String getCompositeName(String svcName, String queueName) {
        return svcName + ":" + queueName;
    }

    public NotificationQueueConfig getConfig() {
        return this.config;
    }

    public Clock getClock() {
        return this.clock;
    }

    public DBBackedQueue<NotificationEventModelDao> getDao() {
        return this.dao;
    }
}

