/*
 * Decompiled with CFR 0.152.
 */
package org.killbill;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.killbill.bus.api.PersistentBusConfig;
import org.killbill.clock.ClockMock;
import org.killbill.commons.embeddeddb.mysql.MySQLEmbeddedDB;
import org.killbill.commons.jdbi.argument.DateTimeArgumentFactory;
import org.killbill.commons.jdbi.argument.DateTimeZoneArgumentFactory;
import org.killbill.commons.jdbi.argument.LocalDateArgumentFactory;
import org.killbill.commons.jdbi.argument.UUIDArgumentFactory;
import org.killbill.commons.jdbi.guice.DaoConfig;
import org.killbill.commons.jdbi.guice.DataSourceProvider;
import org.killbill.commons.jdbi.mapper.UUIDMapper;
import org.killbill.commons.jdbi.notification.DatabaseTransactionNotificationApi;
import org.killbill.commons.jdbi.transaction.NotificationTransactionHandler;
import org.killbill.notificationq.api.NotificationQueueConfig;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;
import org.skife.config.SimplePropertyConfigSource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.tweak.ArgumentFactory;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.tweak.TransactionHandler;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public class TestSetup {
    protected MySQLEmbeddedDBWithDataSource embeddedDB;
    protected DBI dbi;
    protected PersistentBusConfig persistentBusConfig;
    protected NotificationQueueConfig notificationQueueConfig;
    protected ClockMock clock;
    protected MetricRegistry metricRegistry = new MetricRegistry();
    protected DatabaseTransactionNotificationApi databaseTransactionNotificationApi;

    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        TestSetup.loadSystemPropertiesFromClasspath("/queue.properties");
        this.clock = new ClockMock();
        this.embeddedDB = new MySQLEmbeddedDBWithDataSource("killbillq", "killbillq", "killbillq", false);
        this.embeddedDB.initialize();
        this.embeddedDB.start();
        this.embeddedDB.overwriteDataSource();
        String ddl = TestSetup.toString(Resources.getResource((String)"org/killbill/queue/ddl.sql").openStream());
        this.embeddedDB.executeScript(ddl);
        this.embeddedDB.refreshTableNames();
        this.databaseTransactionNotificationApi = new DatabaseTransactionNotificationApi();
        this.dbi = new DBI(this.embeddedDB.getDataSource());
        this.dbi.registerArgumentFactory((ArgumentFactory)new UUIDArgumentFactory());
        this.dbi.registerArgumentFactory((ArgumentFactory)new DateTimeZoneArgumentFactory());
        this.dbi.registerArgumentFactory((ArgumentFactory)new DateTimeArgumentFactory());
        this.dbi.registerArgumentFactory((ArgumentFactory)new LocalDateArgumentFactory());
        this.dbi.registerMapper((ResultSetMapper)new UUIDMapper());
        this.dbi.setTransactionHandler((TransactionHandler)new NotificationTransactionHandler(this.databaseTransactionNotificationApi));
        SimplePropertyConfigSource configSource = new SimplePropertyConfigSource(System.getProperties());
        this.persistentBusConfig = (PersistentBusConfig)new ConfigurationObjectFactory((ConfigSource)configSource).buildWithReplacements(PersistentBusConfig.class, (Map)ImmutableMap.of((Object)"instanceName", (Object)"main"));
        this.notificationQueueConfig = (NotificationQueueConfig)new ConfigurationObjectFactory((ConfigSource)configSource).buildWithReplacements(NotificationQueueConfig.class, (Map)ImmutableMap.of((Object)"instanceName", (Object)"main"));
    }

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        this.embeddedDB.cleanupAllTables();
        this.clock.resetDeltaFromReality();
        this.metricRegistry.removeMatching(MetricFilter.ALL);
    }

    @AfterClass(groups={"slow"})
    public void afterClass() throws Exception {
        this.embeddedDB.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream inputStream) throws IOException {
        try {
            String string = new String(ByteStreams.toByteArray((InputStream)inputStream), Charsets.UTF_8);
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public DBI getDBI() {
        return this.dbi;
    }

    public PersistentBusConfig getPersistentBusConfig() {
        return this.persistentBusConfig;
    }

    public NotificationQueueConfig getNotificationQueueConfig() {
        return this.notificationQueueConfig;
    }

    private static void loadSystemPropertiesFromClasspath(String resource) {
        URL url = TestSetup.class.getResource(resource);
        Assert.assertNotNull((Object)url);
        try {
            System.getProperties().load(url.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public class MySQLEmbeddedDBWithDataSource
    extends MySQLEmbeddedDB {
        public MySQLEmbeddedDBWithDataSource() {
        }

        public MySQLEmbeddedDBWithDataSource(String databaseName, String username, String password, boolean useMariaDB) {
            super(databaseName, username, password, useMariaDB);
        }

        public void overwriteDataSource() {
            this.dataSource = new DataSourceProvider(this.buildDaoConfig(), "TEST_POOL_NAME").get();
        }

        private DaoConfig buildDaoConfig() {
            Properties properties = new Properties();
            properties.put("org.killbill.dao.user", this.username);
            properties.put("org.killbill.dao.password", this.password);
            properties.put("org.killbill.dao.url", this.jdbcConnectionString);
            return (DaoConfig)new ConfigurationObjectFactory(properties).build(DaoConfig.class);
        }
    }
}

