/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.bus;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.UUID;
import org.killbill.bus.api.BusEvent;
import org.killbill.bus.api.PersistentBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;

public class TestEventBusBase {
    protected static final Logger log = LoggerFactory.getLogger(TestEventBusBase.class);
    private final PersistentBus eventBus;

    public TestEventBusBase(PersistentBus eventBus) {
        this.eventBus = eventBus;
    }

    public void testSimpleWithExceptionAndRetrySuccess() {
        try {
            MyEventHandler handler = new MyEventHandler(1, 1);
            this.eventBus.register((Object)handler);
            this.eventBus.post((BusEvent)new MyEvent("my-event", 1L, "MY_EVENT_TYPE", 1L, 2L, UUID.randomUUID()));
            boolean completed = handler.waitForCompletion(5000L);
            Assert.assertEquals((boolean)completed, (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSimpleWithExceptionAndFail() {
        try {
            MyEventHandler handler = new MyEventHandler(1, 4);
            this.eventBus.register((Object)handler);
            this.eventBus.post((BusEvent)new MyEvent("my-event", 1L, "MY_EVENT_TYPE", 1L, 2L, UUID.randomUUID()));
            boolean completed = handler.waitForCompletion(5000L);
            Assert.assertEquals((boolean)completed, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSimple() {
        try {
            int nbEvents = 5;
            MyEventHandler handler = new MyEventHandler(5, 0);
            this.eventBus.register((Object)handler);
            for (int i = 0; i < 5; ++i) {
                this.eventBus.post((BusEvent)new MyEvent("my-event", Long.valueOf(i), "MY_EVENT_TYPE", 1L, 2L, UUID.randomUUID()));
            }
            boolean completed = handler.waitForCompletion(10000L);
            Assert.assertEquals((boolean)completed, (boolean)true);
        }
        catch (Exception e) {
            Assert.fail((String)"", (Throwable)e);
        }
    }

    public void testDifferentType() {
        try {
            MyEventHandler handler = new MyEventHandler(1, 0);
            this.eventBus.register((Object)handler);
            for (int i = 0; i < 5; ++i) {
                this.eventBus.post((BusEvent)new MyOtherEvent("my-other-event", Double.valueOf(i), "MY_EVENT_TYPE", 1L, 2L, UUID.randomUUID()));
            }
            this.eventBus.post((BusEvent)new MyEvent("my-event", 11L, "MY_EVENT_TYPE", 1L, 2L, UUID.randomUUID()));
            boolean completed = handler.waitForCompletion(10000L);
            Assert.assertEquals((boolean)completed, (boolean)true);
        }
        catch (Exception e) {
            Assert.fail((String)"", (Throwable)e);
        }
    }

    public static class MyEventHandler {
        private final int expectedEvents;
        private final int nbThrowExceptions;
        private volatile int gotEvents;
        private volatile int gotExceptions;

        public MyEventHandler(int exp, int nbThrowExceptions) {
            this.expectedEvents = exp;
            this.nbThrowExceptions = nbThrowExceptions;
            this.gotEvents = 0;
            this.gotExceptions = 0;
        }

        public synchronized int getEvents() {
            return this.gotEvents;
        }

        @AllowConcurrentEvents
        @Subscribe
        public void processMyEvent(MyEvent event) {
            if (this.gotExceptions < this.nbThrowExceptions) {
                ++this.gotExceptions;
                throw new MyEventHandlerException("FAIL");
            }
            ++this.gotEvents;
        }

        public synchronized boolean waitForCompletion(long timeoutMs) {
            long ini = System.currentTimeMillis();
            long remaining = timeoutMs;
            while (this.gotEvents < this.expectedEvents && remaining > 0L) {
                try {
                    this.wait(1000L);
                    if (this.gotEvents == this.expectedEvents) break;
                    remaining = timeoutMs - (System.currentTimeMillis() - ini);
                }
                catch (InterruptedException ignore) {}
            }
            return this.gotEvents == this.expectedEvents;
        }
    }

    public static class MyEventHandlerException
    extends RuntimeException {
        private static final long serialVersionUID = 156337823L;

        public MyEventHandlerException(String msg) {
            super(msg);
        }
    }

    public static final class MyOtherEvent
    implements BusEvent {
        private final String name;
        private final Double value;
        private final String type;
        private final Long searchKey1;
        private final Long searchKey2;
        private final UUID userToken;

        @JsonCreator
        public MyOtherEvent(@JsonProperty(value="name") String name, @JsonProperty(value="value") Double value, @JsonProperty(value="type") String type, @JsonProperty(value="searchKey1") Long searchKey1, @JsonProperty(value="searchKey2") Long searchKey2, @JsonProperty(value="userToken") UUID userToken) {
            this.name = name;
            this.value = value;
            this.type = type;
            this.searchKey2 = searchKey2;
            this.searchKey1 = searchKey1;
            this.userToken = userToken;
        }

        public String getName() {
            return this.name;
        }

        public Double getValue() {
            return this.value;
        }

        public String getType() {
            return this.type;
        }

        public Long getSearchKey1() {
            return this.searchKey1;
        }

        public Long getSearchKey2() {
            return this.searchKey2;
        }

        public UUID getUserToken() {
            return this.userToken;
        }
    }

    public static class MyEvent
    implements BusEvent {
        private final String name;
        private final Long value;
        private final String type;
        private final Long searchKey1;
        private final Long searchKey2;
        private final UUID userToken;

        @JsonCreator
        public MyEvent(@JsonProperty(value="name") String name, @JsonProperty(value="value") Long value, @JsonProperty(value="type") String type, @JsonProperty(value="searchKey1") Long searchKey1, @JsonProperty(value="searchKey2") Long searchKey2, @JsonProperty(value="userToken") UUID userToken) {
            this.name = name;
            this.value = value;
            this.type = type;
            this.searchKey2 = searchKey2;
            this.searchKey1 = searchKey1;
            this.userToken = userToken;
        }

        public String getName() {
            return this.name;
        }

        public Long getValue() {
            return this.value;
        }

        public String getType() {
            return this.type;
        }

        public Long getSearchKey1() {
            return this.searchKey1;
        }

        public Long getSearchKey2() {
            return this.searchKey2;
        }

        public UUID getUserToken() {
            return this.userToken;
        }
    }
}

