/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.bus;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.Resources;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.UUID;
import javax.sql.DataSource;
import org.killbill.TestSetup;
import org.killbill.bus.DefaultPersistentBus;
import org.killbill.bus.api.BusEvent;
import org.killbill.bus.api.PersistentBus;
import org.killbill.commons.embeddeddb.mysql.MySQLEmbeddedDB;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestPersistentBusDemo {
    private MySQLEmbeddedDB embeddedDB;
    private DefaultPersistentBus bus;
    private DataSource dataSource;

    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        this.embeddedDB = new MySQLEmbeddedDB("killbillq", "killbillq", "killbillq", false);
        this.embeddedDB.initialize();
        this.embeddedDB.start();
        String ddl = TestSetup.toString(Resources.getResource((String)"org/killbill/queue/ddl.sql").openStream());
        this.embeddedDB.executeScript(ddl);
        String ddlTest = TestSetup.toString(Resources.getResource((String)"queue/ddl_test.sql").openStream());
        this.embeddedDB.executeScript(ddlTest);
        this.embeddedDB.refreshTableNames();
        this.dataSource = this.embeddedDB.getDataSource();
        Properties properties = new Properties();
        properties.setProperty("org.killbill.persistent.bus.main.inMemory", "false");
        properties.setProperty("org.killbill.persistent.bus.main.queue.mode", "STICKY_POLLING");
        properties.setProperty("org.killbill.persistent.bus.main.max.failure.retry", "3");
        properties.setProperty("org.killbill.persistent.bus.main.claimed", "1");
        properties.setProperty("org.killbill.persistent.bus.main.claim.time", "5m");
        properties.setProperty("org.killbill.persistent.bus.main.sleep", "100");
        properties.setProperty("org.killbill.persistent.bus.main.off", "false");
        properties.setProperty("org.killbill.persistent.bus.main.nbThreads", "1");
        properties.setProperty("org.killbill.persistent.bus.main.queue.capacity", "3000");
        properties.setProperty("org.killbill.persistent.bus.main.tableName", "bus_events");
        properties.setProperty("org.killbill.persistent.bus.main.historyTableName", "bus_events_history");
        this.bus = new DefaultPersistentBus(this.dataSource, properties);
    }

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        this.embeddedDB.cleanupAllTables();
        this.bus.start();
    }

    @AfterMethod(groups={"slow"})
    public void afterMethod() throws Exception {
        this.bus.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"slow"})
    public void testDemo() throws SQLException, PersistentBus.EventBusException {
        DummyHandler handler = new DummyHandler();
        this.bus.register((Object)handler);
        Connection connection = this.dataSource.getConnection();
        DummyEvent event = new DummyEvent("foo", 1L, 2L, UUID.randomUUID());
        Statement stmt = null;
        try {
            connection.setAutoCommit(false);
            stmt = connection.prepareStatement("insert into dummy (dkey, dvalue) values (?, ?)");
            stmt.setString(1, "Great!");
            stmt.setLong(2, 47L);
            stmt.executeUpdate();
            this.bus.postFromTransaction((BusEvent)event, connection);
            connection.commit();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        Connection connection2 = this.dataSource.getConnection();
        PreparedStatement stmt2 = null;
        try {
            stmt2 = connection2.prepareStatement("select * from dummy where dkey = ?");
            stmt2.setString(1, "Great!");
            ResultSet rs2 = stmt2.executeQuery();
            int found = 0;
            while (rs2.next()) {
                ++found;
            }
            Assert.assertEquals((int)found, (int)1);
        }
        finally {
            stmt2.close();
        }
        if (connection2 != null) {
            connection2.close();
        }
        Assert.assertTrue((boolean)handler.waitForCompletion(1, 3000L));
    }

    public static class DummyHandler {
        private int nbEvents = 0;

        @AllowConcurrentEvents
        @Subscribe
        public void processEvent(DummyEvent event) {
            ++this.nbEvents;
        }

        public synchronized boolean waitForCompletion(int expectedEvents, long timeoutMs) {
            long ini = System.currentTimeMillis();
            long remaining = timeoutMs;
            while (this.nbEvents < expectedEvents && remaining > 0L) {
                try {
                    this.wait(1000L);
                    if (this.nbEvents == expectedEvents) break;
                    remaining = timeoutMs - (System.currentTimeMillis() - ini);
                }
                catch (InterruptedException ignore) {}
            }
            return this.nbEvents == expectedEvents;
        }
    }

    public static class DummyEvent
    implements BusEvent {
        private final String name;
        private final Long searchKey1;
        private final Long searchKey2;
        private final UUID userToken;

        @JsonCreator
        public DummyEvent(@JsonProperty(value="name") String name, @JsonProperty(value="searchKey1") Long searchKey1, @JsonProperty(value="searchKey2") Long searchKey2, @JsonProperty(value="userToken") UUID userToken) {
            this.name = name;
            this.searchKey2 = searchKey2;
            this.searchKey1 = searchKey1;
            this.userToken = userToken;
        }

        public String getName() {
            return this.name;
        }

        public Long getSearchKey1() {
            return this.searchKey1;
        }

        public Long getSearchKey2() {
            return this.searchKey2;
        }

        public UUID getUserToken() {
            return this.userToken;
        }
    }
}

