/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.notificationq;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.inject.Inject;
import org.killbill.CreatorName;
import org.killbill.clock.Clock;
import org.killbill.notificationq.MockNotificationQueue;
import org.killbill.notificationq.NotificationQueueServiceBase;
import org.killbill.notificationq.api.NotificationEvent;
import org.killbill.notificationq.api.NotificationQueue;
import org.killbill.notificationq.api.NotificationQueueConfig;
import org.killbill.notificationq.api.NotificationQueueService;
import org.killbill.notificationq.dao.NotificationEventModelDao;
import org.killbill.queue.api.PersistentQueueEntryLifecycleState;
import org.killbill.queue.dao.EventEntryModelDao;
import org.killbill.queue.dispatching.CallableCallbackBase;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.IDBI;

public class MockNotificationQueueService
extends NotificationQueueServiceBase {
    @Inject
    public MockNotificationQueueService(Clock clock, NotificationQueueConfig config, DBI dbi, MetricRegistry metricRegistry) {
        super(clock, config, (IDBI)dbi, metricRegistry);
    }

    protected NotificationQueue createNotificationQueueInternal(String svcName, String queueName, NotificationQueueService.NotificationQueueHandler handler) {
        return new MockNotificationQueue(this.clock, svcName, queueName, handler, this);
    }

    public int doProcessEvents() {
        int retry = 2;
        while (true) {
            try {
                int result = 0;
                for (String queueName : this.queues.keySet()) {
                    NotificationQueue cur = (NotificationQueue)this.queues.get(queueName);
                    if (cur == null) continue;
                    result += this.doProcessEventsForQueue((MockNotificationQueue)cur);
                }
                return result;
            }
            catch (ConcurrentModificationException e) {
                if (--retry > 0) continue;
                return 0;
            }
            break;
        }
    }

    private int doProcessEventsForQueue(MockNotificationQueue queue) {
        int result = 0;
        ArrayList<NotificationEventModelDao> processedNotifications = new ArrayList<NotificationEventModelDao>();
        ArrayList<NotificationEventModelDao> oldNotifications = new ArrayList<NotificationEventModelDao>();
        List<NotificationEventModelDao> readyNotifications = queue.getReadyNotifications();
        for (NotificationEventModelDao cur : readyNotifications) {
            NotificationEvent key = (NotificationEvent)CallableCallbackBase.deserializeEvent((EventEntryModelDao)cur, (ObjectMapper)this.objectMapper);
            queue.getHandler().handleReadyNotification(key, cur.getEffectiveDate(), cur.getFutureUserToken(), cur.getSearchKey1(), cur.getSearchKey2());
            NotificationEventModelDao processedNotification = new NotificationEventModelDao(cur.getRecordId().longValue(), CreatorName.get(), CreatorName.get(), this.clock.getUTCNow(), this.getClock().getUTCNow().plus(300000L), PersistentQueueEntryLifecycleState.PROCESSED, cur.getClassName(), cur.getEventJson(), Long.valueOf(0L), cur.getUserToken(), cur.getSearchKey1(), cur.getSearchKey2(), cur.getFutureUserToken(), cur.getEffectiveDate(), "MockQueue");
            oldNotifications.add(cur);
            processedNotifications.add(processedNotification);
            ++result;
        }
        queue.markProcessedNotifications(oldNotifications, processedNotifications);
        return result;
    }
}

