/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.metrics;

import com.codahale.metrics.MetricRegistry;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.spi.container.ExceptionMapperContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Provider;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.killbill.commons.metrics.MetricTag;
import org.killbill.commons.skeleton.metrics.ResourceTimer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedResourceInterceptor
implements MethodInterceptor {
    private final Map<String, Map<String, Object>> metricTagsByMethod = new ConcurrentHashMap<String, Map<String, Object>>();
    private final Provider<GuiceContainer> jerseyContainer;
    private final Provider<MetricRegistry> metricRegistry;
    private final String resourcePath;
    private final String metricName;
    private final String httpMethod;

    public TimedResourceInterceptor(Provider<GuiceContainer> jerseyContainer, Provider<MetricRegistry> metricRegistry, String resourcePath, String metricName, String httpMethod) {
        this.jerseyContainer = jerseyContainer;
        this.metricRegistry = metricRegistry;
        this.resourcePath = resourcePath;
        this.metricName = metricName;
        this.httpMethod = httpMethod;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        long startTime = System.nanoTime();
        int responseStatus = 0;
        try {
            Object response = invocation.proceed();
            responseStatus = response instanceof Response ? ((Response)response).getStatus() : (response == null || response instanceof Void ? Response.Status.NO_CONTENT.getStatusCode() : Response.Status.OK.getStatusCode());
            Object object = response;
            return object;
        }
        catch (WebApplicationException e) {
            responseStatus = e.getResponse().getStatus();
            throw e;
        }
        catch (Throwable e) {
            responseStatus = this.mapException(e);
            throw e;
        }
        finally {
            long endTime = System.nanoTime();
            ResourceTimer timer = this.timer(invocation);
            timer.update(responseStatus, endTime - startTime, TimeUnit.NANOSECONDS);
        }
    }

    private int mapException(Throwable e) throws Exception {
        ExceptionMapperContext exceptionMapperContext = ((GuiceContainer)this.jerseyContainer.get()).getWebApplication().getExceptionMapperContext();
        ExceptionMapper exceptionMapper = exceptionMapperContext.find(e.getClass());
        if (exceptionMapper != null) {
            return exceptionMapper.toResponse(e).getStatus();
        }
        return Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
    }

    private ResourceTimer timer(MethodInvocation invocation) {
        Map<String, Object> metricTags = this.metricTags(invocation);
        return new ResourceTimer(this.resourcePath, this.metricName, this.httpMethod, metricTags, (MetricRegistry)this.metricRegistry.get());
    }

    private Map<String, Object> metricTags(MethodInvocation invocation) {
        Method method = invocation.getMethod();
        String methodString = method.toString();
        Map<String, Object> metricTags = this.metricTagsByMethod.get(methodString);
        if (metricTags != null) {
            return metricTags;
        }
        metricTags = new LinkedHashMap<String, Object>();
        Annotation[][] parametersAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parametersAnnotations.length; ++i) {
            Annotation[] parameterAnnotations = parametersAnnotations[i];
            MetricTag metricTag = TimedResourceInterceptor.findMetricTagAnnotations(parameterAnnotations);
            if (metricTag == null) continue;
            Object currentArgument = invocation.getArguments()[i];
            Object tagValue = metricTag.property().trim().isEmpty() ? currentArgument : TimedResourceInterceptor.getProperty(currentArgument, metricTag.property());
            metricTags.put(metricTag.tag(), tagValue);
        }
        this.metricTagsByMethod.put(methodString, metricTags);
        return metricTags;
    }

    private static MetricTag findMetricTagAnnotations(Annotation[] parameterAnnotations) {
        for (Annotation parameterAnnotation : parameterAnnotations) {
            if (!(parameterAnnotation instanceof MetricTag)) continue;
            return (MetricTag)parameterAnnotation;
        }
        return null;
    }

    private static Object getProperty(Object currentArgument, String property) {
        if (currentArgument == null) {
            return null;
        }
        try {
            String[] methodNames = new String[]{"get" + TimedResourceInterceptor.capitalize(property), "is" + TimedResourceInterceptor.capitalize(property), property};
            Method propertyMethod = null;
            for (String methodName : methodNames) {
                try {
                    propertyMethod = currentArgument.getClass().getMethod(methodName, new Class[0]);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            if (propertyMethod == null) {
                throw TimedResourceInterceptor.handleReadPropertyError(currentArgument, property, null);
            }
            return propertyMethod.invoke(currentArgument, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw TimedResourceInterceptor.handleReadPropertyError(currentArgument, property, e);
        }
        catch (InvocationTargetException e) {
            throw TimedResourceInterceptor.handleReadPropertyError(currentArgument, property, e);
        }
    }

    private static String capitalize(String property) {
        return property.substring(0, 1).toUpperCase() + property.substring(1);
    }

    private static IllegalArgumentException handleReadPropertyError(Object object, String property, Exception e) {
        return new IllegalArgumentException(String.format("Failed to read tag property \"%s\" value from object of type %s", property, object.getClass()), e);
    }
}

