/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.metrics;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.inject.Provider;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import org.aopalliance.intercept.MethodInterceptor;
import org.killbill.commons.metrics.TimedResource;
import org.killbill.commons.skeleton.metrics.TimedResourceInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedResourceListener
implements TypeListener {
    private final Provider<GuiceContainer> guiceContainer;
    private final Provider<MetricRegistry> metricRegistry;

    public TimedResourceListener(Provider<GuiceContainer> guiceContainer, Provider<MetricRegistry> metricRegistry) {
        this.guiceContainer = guiceContainer;
        this.metricRegistry = metricRegistry;
    }

    public <T> void hear(TypeLiteral<T> literal, TypeEncounter<T> encounter) {
        Path pathAnnotation = literal.getRawType().getAnnotation(Path.class);
        if (pathAnnotation != null) {
            String resourcePath = pathAnnotation.value();
            for (Method method : literal.getRawType().getMethods()) {
                HttpMethod httpMethod;
                TimedResource annotation = method.getAnnotation(TimedResource.class);
                if (annotation == null || (httpMethod = this.resourceHttpMethod(method)) == null) continue;
                String metricName = !annotation.name().trim().isEmpty() ? annotation.name() : method.getName();
                TimedResourceInterceptor timedResourceInterceptor = new TimedResourceInterceptor(this.guiceContainer, this.metricRegistry, resourcePath, metricName, httpMethod.value());
                encounter.bindInterceptor(Matchers.only((Object)method), new MethodInterceptor[]{timedResourceInterceptor});
            }
        }
    }

    private HttpMethod resourceHttpMethod(Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            HttpMethod httpMethod = annotation.annotationType().getAnnotation(HttpMethod.class);
            if (httpMethod == null) continue;
            return httpMethod;
        }
        return null;
    }
}

