/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.metrics.health;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.inject.Inject;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KillBillHealthCheckRegistry
extends HealthCheckRegistry {
    private static final Logger logger = LoggerFactory.getLogger(KillBillHealthCheckRegistry.class);

    @Inject
    public void initialize(Set<HealthCheck> healthChecks) {
        for (HealthCheck healthCheck : healthChecks) {
            this.register(healthCheck.getClass().getName(), healthCheck);
        }
    }

    public HealthCheck.Result runHealthCheck(String name) throws NoSuchElementException {
        HealthCheck.Result result = super.runHealthCheck(name);
        this.logUnHealthyResult(name, result);
        return result;
    }

    public SortedMap<String, HealthCheck.Result> runHealthChecks() {
        SortedMap results = super.runHealthChecks();
        this.logUnHealthyResults(results);
        return results;
    }

    public SortedMap<String, HealthCheck.Result> runHealthChecks(ExecutorService executor) {
        SortedMap results = super.runHealthChecks(executor);
        this.logUnHealthyResults(results);
        return results;
    }

    private void logUnHealthyResults(Map<String, HealthCheck.Result> results) {
        for (String healthCheckName : results.keySet()) {
            HealthCheck.Result result = results.get(healthCheckName);
            this.logUnHealthyResult(healthCheckName, result);
        }
    }

    private void logUnHealthyResult(String healthCheckName, HealthCheck.Result healthCheckResult) {
        if (!healthCheckResult.isHealthy()) {
            logger.warn("HealthCheck {} failed: {}", (Object)healthCheckName, (Object)healthCheckResult.toString());
        }
    }
}

