/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.modules;

import com.google.common.collect.Maps;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.http.HttpServlet;
import org.killbill.commons.skeleton.modules.BaseServerModule;
import org.killbill.commons.skeleton.modules.JerseyBaseServerModule;

public class BaseServerModuleBuilder {
    private String jaxrsUriPattern = "/.*";
    private final List<String> jaxrsResources = new ArrayList<String>();
    private final List<Module> modules = new ArrayList<Module>();
    private final Map<String, ArrayList<Map.Entry<Class<? extends Filter>, Map<String, String>>>> filters = new HashMap<String, ArrayList<Map.Entry<Class<? extends Filter>, Map<String, String>>>>();
    private final Map<String, ArrayList<Map.Entry<Class<? extends Filter>, Map<String, String>>>> filtersRegex = new HashMap<String, ArrayList<Map.Entry<Class<? extends Filter>, Map<String, String>>>>();
    private final Map<String, Class<? extends HttpServlet>> jaxrsServlets = new HashMap<String, Class<? extends HttpServlet>>();
    private final Map<String, Class<? extends HttpServlet>> jaxrsServletsRegex = new HashMap<String, Class<? extends HttpServlet>>();
    private final Map<String, Class<? extends HttpServlet>> servlets = new HashMap<String, Class<? extends HttpServlet>>();
    private final Map<String, Class<? extends HttpServlet>> servletsRegex = new HashMap<String, Class<? extends HttpServlet>>();
    private final List<String> jerseyFilters = new ArrayList<String>();
    private final Map<String, String> jerseyParams = new HashMap<String, String>();
    private JaxrsImplementation jaxrsImplementation = JaxrsImplementation.JERSEY;

    public BaseServerModuleBuilder addFilter(String urlPattern, Class<? extends Filter> filterKey) {
        return this.addFilter(urlPattern, filterKey, new HashMap<String, String>());
    }

    public BaseServerModuleBuilder addFilter(String urlPattern, Class<? extends Filter> filterKey, Map<String, String> initParams) {
        if (this.filters.get(urlPattern) == null) {
            this.filters.put(urlPattern, new ArrayList());
        }
        this.filters.get(urlPattern).add(Maps.immutableEntry(filterKey, initParams));
        return this;
    }

    public BaseServerModuleBuilder addFilterRegex(String urlPattern, Class<? extends Filter> filterKey) {
        return this.addFilterRegex(urlPattern, filterKey, new HashMap<String, String>());
    }

    public BaseServerModuleBuilder addFilterRegex(String urlPattern, Class<? extends Filter> filterKey, Map<String, String> initParams) {
        if (this.filtersRegex.get(urlPattern) == null) {
            this.filtersRegex.put(urlPattern, new ArrayList());
        }
        this.filtersRegex.get(urlPattern).add(Maps.immutableEntry(filterKey, initParams));
        return this;
    }

    public BaseServerModuleBuilder addServlet(String urlPattern, Class<? extends HttpServlet> filterKey) {
        this.servlets.put(urlPattern, filterKey);
        return this;
    }

    public BaseServerModuleBuilder addServletRegex(String urlPattern, Class<? extends HttpServlet> filterKey) {
        this.servletsRegex.put(urlPattern, filterKey);
        return this;
    }

    public BaseServerModuleBuilder addJaxrsServlet(String urlPattern, Class<? extends HttpServlet> filterKey) {
        this.jaxrsServlets.put(urlPattern, filterKey);
        return this;
    }

    public BaseServerModuleBuilder addJaxrsServletRegex(String urlPattern, Class<? extends HttpServlet> filterKey) {
        this.jaxrsServletsRegex.put(urlPattern, filterKey);
        return this;
    }

    public BaseServerModuleBuilder addJerseyFilter(String filterClassName) {
        this.jerseyFilters.add(filterClassName);
        return this;
    }

    public BaseServerModuleBuilder addJerseyParam(String key, String value) {
        this.jerseyParams.put(key, value);
        return this;
    }

    public BaseServerModuleBuilder setJaxrsUriPattern(String jaxrsUriPattern) {
        this.jaxrsUriPattern = jaxrsUriPattern;
        return this;
    }

    public BaseServerModuleBuilder addJaxrsResource(String resource) {
        this.jaxrsResources.add(resource);
        return this;
    }

    public BaseServerModuleBuilder setJaxrsImplementation(JaxrsImplementation jaxrsImplementation) {
        this.jaxrsImplementation = jaxrsImplementation;
        return this;
    }

    public BaseServerModule build() {
        switch (this.jaxrsImplementation) {
            case NONE: {
                return new BaseServerModule(this.filters, this.filtersRegex, this.servlets, this.servletsRegex, this.jaxrsServlets, this.jaxrsServletsRegex, this.jaxrsUriPattern, this.jaxrsResources);
            }
            case JERSEY: {
                return new JerseyBaseServerModule(this.filters, this.filtersRegex, this.servlets, this.servletsRegex, this.jaxrsServlets, this.jaxrsServletsRegex, this.jaxrsUriPattern, this.jaxrsResources, this.jerseyFilters, this.jerseyParams);
            }
        }
        throw new IllegalArgumentException();
    }

    public static enum JaxrsImplementation {
        NONE,
        JERSEY;

    }
}

