/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.modules;

import com.google.inject.Injector;
import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.io.IOException;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

@Singleton
public class Jersey2CompatGuiceContainer
extends GuiceContainer {
    @Inject
    public Jersey2CompatGuiceContainer(Injector injector) {
        super(injector);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String encodedBasePath;
        String decodedBasePath;
        int i;
        UriBuilder absoluteUriBuilder;
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        StringBuffer requestURL = request.getRequestURL();
        String requestURI = request.getRequestURI();
        boolean checkPathInfo = pathInfo == null || pathInfo.isEmpty() || pathInfo.equals("/");
        try {
            absoluteUriBuilder = Jersey2CompatGuiceContainer.fromUriJersey2Compat(requestURL.toString());
        }
        catch (IllegalArgumentException iae) {
            Response.Status badRequest = Response.Status.BAD_REQUEST;
            response.sendError(badRequest.getStatusCode(), badRequest.getReasonPhrase());
            return;
        }
        if (checkPathInfo && !request.getRequestURI().endsWith("/") && servletPath.substring((i = servletPath.lastIndexOf("/")) + 1).indexOf(46) < 0) {
            requestURL.append("/");
            requestURI = requestURI + "/";
        }
        if (!(decodedBasePath = request.getContextPath() + servletPath + "/").equals(encodedBasePath = UriComponent.encode((String)decodedBasePath, (UriComponent.Type)UriComponent.Type.PATH))) {
            throw new ContainerException("The servlet context path and/or the servlet path contain characters that are percent encoded");
        }
        URI baseUri = absoluteUriBuilder.replacePath(encodedBasePath).build(new Object[0]);
        String queryParameters = request.getQueryString();
        if (queryParameters == null) {
            queryParameters = "";
        }
        URI requestUri = absoluteUriBuilder.replacePath(requestURI).replaceQuery(queryParameters).build(new Object[0]);
        this.service(baseUri, requestUri, request, response);
    }

    public static UriBuilder fromUriJersey2Compat(String uri) throws IllegalArgumentException {
        URI u;
        try {
            u = URI.create(uri);
        }
        catch (NullPointerException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        return UriBuilder.fromUri((URI)u);
    }
}

