/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.modules;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.http.HttpServlet;
import org.killbill.commons.skeleton.modules.BaseServerModule;

public class JerseyBaseServerModule
extends BaseServerModule {
    private static final Joiner joiner = Joiner.on((String)";");
    @VisibleForTesting
    static final String JERSEY_CONTAINER_REQUEST_FILTERS = "com.sun.jersey.spi.container.ContainerRequestFilters";
    @VisibleForTesting
    static final String JERSEY_CONTAINER_RESPONSE_FILTERS = "com.sun.jersey.spi.container.ContainerResponseFilters";
    @VisibleForTesting
    static final String JERSEY_DISABLE_ENTITYLOGGING = "com.sun.jersey.config.feature.logging.DisableEntitylogging";
    protected final ImmutableMap.Builder<String, String> jerseyParams;

    public JerseyBaseServerModule(Map<String, ArrayList<Map.Entry<Class<? extends Filter>, Map<String, String>>>> filters, Map<String, ArrayList<Map.Entry<Class<? extends Filter>, Map<String, String>>>> filtersRegex, Map<String, Class<? extends HttpServlet>> servlets, Map<String, Class<? extends HttpServlet>> servletsRegex, Map<String, Class<? extends HttpServlet>> jaxrsServlets, Map<String, Class<? extends HttpServlet>> jaxrsServletsRegex, String jaxrsUriPattern, Collection<String> jaxrsResources, List<String> jerseyFilters, Map<String, String> jerseyParams) {
        super(filters, filtersRegex, servlets, servletsRegex, jaxrsServlets, jaxrsServletsRegex, jaxrsUriPattern, jaxrsResources);
        String manuallySpecifiedRequestFilters = Strings.nullToEmpty((String)jerseyParams.remove(JERSEY_CONTAINER_REQUEST_FILTERS));
        String manuallySpecifiedResponseFilters = Strings.nullToEmpty((String)jerseyParams.remove(JERSEY_CONTAINER_RESPONSE_FILTERS));
        if (!jerseyFilters.isEmpty()) {
            if (!manuallySpecifiedRequestFilters.isEmpty()) {
                manuallySpecifiedRequestFilters = manuallySpecifiedRequestFilters + ";";
            }
            if (!manuallySpecifiedResponseFilters.isEmpty()) {
                manuallySpecifiedResponseFilters = manuallySpecifiedResponseFilters + ";";
            }
        }
        String containerRequestFilters = manuallySpecifiedRequestFilters + joiner.join(jerseyFilters);
        String containerResponseFilters = manuallySpecifiedResponseFilters + joiner.join((Iterable)Lists.reverse(jerseyFilters));
        this.jerseyParams = new ImmutableMap.Builder();
        if (!containerRequestFilters.isEmpty()) {
            this.jerseyParams.put((Object)JERSEY_CONTAINER_REQUEST_FILTERS, (Object)containerRequestFilters);
        }
        if (!containerResponseFilters.isEmpty()) {
            this.jerseyParams.put((Object)JERSEY_CONTAINER_RESPONSE_FILTERS, (Object)containerResponseFilters);
        }
        String disableEntityLogging = (String)MoreObjects.firstNonNull((Object)Strings.emptyToNull((String)jerseyParams.remove(JERSEY_DISABLE_ENTITYLOGGING)), (Object)"true");
        this.jerseyParams.put((Object)JERSEY_DISABLE_ENTITYLOGGING, (Object)disableEntityLogging).putAll(jerseyParams);
    }

    @Override
    protected void configureResources() {
        for (String urlPattern : this.jaxrsServlets.keySet()) {
            this.serve(urlPattern, new String[0]).with((Class)this.jaxrsServlets.get(urlPattern), (Map)this.jerseyParams.build());
        }
        for (String urlPattern : this.jaxrsServletsRegex.keySet()) {
            this.serveRegex(urlPattern, new String[0]).with((Class)this.jaxrsServletsRegex.get(urlPattern), (Map)this.jerseyParams.build());
        }
        if (!this.jaxrsResources.isEmpty()) {
            this.jerseyParams.put((Object)"com.sun.jersey.config.property.packages", (Object)joiner.join((Iterable)this.jaxrsResources));
            this.serveJaxrsResources();
        }
    }

    protected void serveJaxrsResources() {
        this.serveRegex(this.jaxrsUriPattern, new String[0]).with(GuiceContainer.class, (Map)this.jerseyParams.build());
    }

    @VisibleForTesting
    ImmutableMap.Builder<String, String> getJerseyParams() {
        return this.jerseyParams;
    }
}

