/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.modules;

import com.google.inject.servlet.ServletModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.http.HttpServlet;

public class BaseServerModule
extends ServletModule {
    private final Map<String, ArrayList<Map.Entry<Class<? extends Filter>, Map<String, String>>>> filters;
    private final Map<String, ArrayList<Map.Entry<Class<? extends Filter>, Map<String, String>>>> filtersRegex;
    private final Map<String, Class<? extends HttpServlet>> servlets;
    private final Map<String, Class<? extends HttpServlet>> servletsRegex;
    final Map<String, Class<? extends HttpServlet>> jaxrsServlets;
    final Map<String, Class<? extends HttpServlet>> jaxrsServletsRegex;
    final String jaxrsUriPattern;
    final Collection<String> jaxrsResources = new ArrayList<String>();

    public BaseServerModule(Map<String, ArrayList<Map.Entry<Class<? extends Filter>, Map<String, String>>>> filters, Map<String, ArrayList<Map.Entry<Class<? extends Filter>, Map<String, String>>>> filtersRegex, Map<String, Class<? extends HttpServlet>> servlets, Map<String, Class<? extends HttpServlet>> servletsRegex, Map<String, Class<? extends HttpServlet>> jaxrsServlets, Map<String, Class<? extends HttpServlet>> jaxrsServletsRegex, String jaxrsUriPattern, Collection<String> jaxrsResources) {
        this.filters = filters;
        this.filtersRegex = filtersRegex;
        this.servlets = servlets;
        this.servletsRegex = servletsRegex;
        this.jaxrsServlets = jaxrsServlets;
        this.jaxrsServletsRegex = jaxrsServletsRegex;
        this.jaxrsUriPattern = jaxrsUriPattern;
        this.jaxrsResources.addAll(jaxrsResources);
    }

    public void configureServlets() {
        super.configureServlets();
        this.configureFilters();
        this.configureFiltersRegex();
        this.configureRegularServlets();
        this.configureRegularServletsRegex();
        this.configureResources();
    }

    protected void configureFilters() {
        for (String urlPattern : this.filters.keySet()) {
            for (Map.Entry<Class<? extends Filter>, Map<String, String>> filter : this.filters.get(urlPattern)) {
                this.filter(urlPattern, new String[0]).through(filter.getKey(), filter.getValue());
            }
        }
    }

    protected void configureFiltersRegex() {
        for (String urlPattern : this.filtersRegex.keySet()) {
            for (Map.Entry<Class<? extends Filter>, Map<String, String>> filter : this.filtersRegex.get(urlPattern)) {
                this.filterRegex(urlPattern, new String[0]).through(filter.getKey(), filter.getValue());
            }
        }
    }

    protected void configureRegularServlets() {
        for (String urlPattern : this.servlets.keySet()) {
            this.serve(urlPattern, new String[0]).with(this.servlets.get(urlPattern));
        }
    }

    protected void configureRegularServletsRegex() {
        for (String urlPattern : this.servletsRegex.keySet()) {
            this.serveRegex(urlPattern, new String[0]).with(this.servletsRegex.get(urlPattern));
        }
    }

    protected void configureResources() {
        for (String urlPattern : this.jaxrsServlets.keySet()) {
            this.serve(urlPattern, new String[0]).with(this.jaxrsServlets.get(urlPattern));
        }
        for (String urlPattern : this.jaxrsServletsRegex.keySet()) {
            this.serveRegex(urlPattern, new String[0]).with(this.jaxrsServletsRegex.get(urlPattern));
        }
    }
}

