/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.listeners;

import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class JULServletContextListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent event) {
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        Handler[] handlers = rootLogger.getHandlers();
        if (handlers != null) {
            for (Handler handler : handlers) {
                rootLogger.removeHandler(handler);
            }
        }
        JULServletContextListener.removeHandlersForRootLoggerHierarchy();
        SLF4JBridgeHandler.install();
    }

    private static void removeHandlersForRootLoggerHierarchy() {
        for (Logger rootLogger = LogManager.getLogManager().getLogger(""); rootLogger != null; rootLogger = rootLogger.getParent()) {
            JULServletContextListener.removeHandlersForRootLogger(rootLogger);
        }
    }

    private static void removeHandlersForRootLogger(Logger rootLogger) {
        Handler[] handlers = rootLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            rootLogger.removeHandler(handlers[i]);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        SLF4JBridgeHandler.uninstall();
    }
}

