/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.modules;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import com.palominolabs.metrics.guice.MetricsInstrumentationModule;
import org.killbill.commons.skeleton.metrics.health.KillBillHealthCheckRegistry;
import org.killbill.commons.skeleton.modules.AdminServletModule;

public class StatsModule
extends AbstractModule {
    private final String healthCheckUri;
    private final String metricsUri;
    private final String pingUri;
    private final String threadsUri;
    private final Iterable<Class<? extends HealthCheck>> healthChecks;

    public StatsModule() {
        this((Iterable<Class<? extends HealthCheck>>)ImmutableList.of());
    }

    public StatsModule(Class<? extends HealthCheck> healthCheck) {
        this((Iterable<Class<? extends HealthCheck>>)ImmutableList.of(healthCheck));
    }

    public StatsModule(Class<? extends HealthCheck> ... healthChecks) {
        this((Iterable<Class<? extends HealthCheck>>)ImmutableList.copyOf((Object[])healthChecks));
    }

    public StatsModule(Iterable<Class<? extends HealthCheck>> healthChecks) {
        this("/1.0/healthcheck", "/1.0/metrics", "/1.0/ping", "/1.0/threads", healthChecks);
    }

    public StatsModule(String healthCheckUri, String metricsUri, String pingUri, String threadsUri, Iterable<Class<? extends HealthCheck>> healthChecks) {
        this.healthCheckUri = healthCheckUri;
        this.metricsUri = metricsUri;
        this.pingUri = pingUri;
        this.threadsUri = threadsUri;
        this.healthChecks = healthChecks;
    }

    protected void configure() {
        MetricRegistry metricRegistry = this.createMetricRegistry();
        this.bind(MetricRegistry.class).toInstance((Object)metricRegistry);
        this.install((Module)MetricsInstrumentationModule.builder().withMetricRegistry(metricRegistry).build());
        Multibinder healthChecksBinder = Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class);
        for (Class<? extends HealthCheck> healthCheckClass : this.healthChecks) {
            healthChecksBinder.addBinding().to(healthCheckClass).asEagerSingleton();
        }
        this.install((Module)new AdminServletModule(this.healthCheckUri, this.metricsUri, this.pingUri, this.threadsUri));
        this.bind(HealthCheckRegistry.class).toInstance((Object)this.createHealthCheckRegistry());
    }

    protected HealthCheckRegistry createHealthCheckRegistry() {
        return new KillBillHealthCheckRegistry();
    }

    protected MetricRegistry createMetricRegistry() {
        return new MetricRegistry();
    }
}

