/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ResourceTimer {
    private static final Joiner METRIC_NAME_JOINER = Joiner.on((char)'.');
    private final String resourcePath;
    private final String name;
    private final String httpMethod;
    private final Map<String, Object> tags;
    private final MetricRegistry registry;

    public ResourceTimer(String resourcePath, String name, String httpMethod, Map<String, Object> tags, MetricRegistry registry) {
        this.resourcePath = resourcePath;
        this.name = name;
        this.httpMethod = httpMethod;
        this.tags = tags;
        this.registry = registry;
    }

    public void update(int responseStatus, long duration, TimeUnit unit) {
        String metricName;
        if (this.tags != null && !this.tags.isEmpty()) {
            String tags = METRIC_NAME_JOINER.join(this.getTagsValues());
            metricName = METRIC_NAME_JOINER.join(this.escapeMetrics("kb_resource", this.resourcePath, this.name, this.httpMethod, tags, this.responseStatusGroup(responseStatus), responseStatus));
        } else {
            metricName = METRIC_NAME_JOINER.join(this.escapeMetrics("kb_resource", this.resourcePath, this.name, this.httpMethod, this.responseStatusGroup(responseStatus), responseStatus));
        }
        Timer timer = this.registry.timer(metricName);
        timer.update(duration, unit);
    }

    private List<String> escapeMetrics(Object ... names) {
        ArrayList<String> result = new ArrayList<String>(names.length);
        for (Object name : names) {
            String metricName = String.valueOf(name);
            result.add(metricName.replaceAll("\\.", "_"));
        }
        return result;
    }

    private List<Object> getTagsValues() {
        ArrayList<Object> values = new ArrayList<Object>(this.tags.values().size());
        for (Object value : this.tags.values()) {
            if (value != null) {
                values.add(value);
                continue;
            }
            values.add("null");
        }
        return values;
    }

    private String responseStatusGroup(int responseStatus) {
        return String.format("%sxx", responseStatus / 100);
    }
}

