/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.modules;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.servlet.ServletContainer;
import org.glassfish.jersey.servlet.WebConfig;
import org.glassfish.jersey.spi.ExceptionMappers;
import org.jvnet.hk2.guice.bridge.api.GuiceBridge;
import org.jvnet.hk2.guice.bridge.api.GuiceIntoHK2Bridge;
import org.killbill.commons.skeleton.modules.TimedInterceptionService;

@Singleton
public class GuiceServletContainer
extends ServletContainer {
    private final Injector injector;

    @Inject
    public GuiceServletContainer(Injector injector) {
        this.injector = injector;
    }

    protected void init(WebConfig webConfig) throws ServletException {
        boolean hasObjectMapperBinding;
        super.init(webConfig);
        InjectionManager injectionManager = this.getApplicationHandler().getInjectionManager();
        ServiceLocator serviceLocator = (ServiceLocator)injectionManager.getInstance(ServiceLocator.class);
        GuiceBridge.getGuiceBridge().initializeGuiceBridge(serviceLocator);
        GuiceIntoHK2Bridge guiceBridge = (GuiceIntoHK2Bridge)serviceLocator.getService(GuiceIntoHK2Bridge.class, new Annotation[0]);
        guiceBridge.bridgeGuiceInjector(this.injector);
        String scannedResourcePackagesString = webConfig.getInitParameter("jersey.config.server.provider.packages");
        if (Strings.emptyToNull((String)scannedResourcePackagesString) != null) {
            ImmutableSet scannedResourcePackages = ImmutableSet.copyOf((Iterable)Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)" ,;\n")).split((CharSequence)scannedResourcePackagesString));
            ServiceLocatorUtilities.addOneConstant((ServiceLocator)serviceLocator, (Object)new TimedInterceptionService((Set<String>)scannedResourcePackages, (ExceptionMappers)injectionManager.getInstance(ExceptionMappers.class), (MetricRegistry)this.injector.getInstance(MetricRegistry.class)));
        }
        boolean bl = hasObjectMapperBinding = !this.injector.findBindingsByType(TypeLiteral.get(ObjectMapper.class)).isEmpty();
        if (hasObjectMapperBinding) {
            ObjectMapper objectMapper = (ObjectMapper)this.injector.getInstance(ObjectMapper.class);
            for (MessageBodyWriter messageBodyWriter : injectionManager.getAllInstances(MessageBodyWriter.class)) {
                if (!(messageBodyWriter instanceof JacksonJsonProvider)) continue;
                ((JacksonJsonProvider)messageBodyWriter).setMapper(objectMapper);
                break;
            }
        }
    }
}

