/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.modules;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.http.HttpServlet;
import org.killbill.commons.skeleton.modules.BaseServerModule;
import org.killbill.commons.skeleton.modules.GuiceServletContainer;

public class JerseyBaseServerModule
extends BaseServerModule {
    private static final Joiner joiner = Joiner.on((String)";");
    @VisibleForTesting
    static final String JERSEY_LOGGING_VERBOSITY = "jersey.config.logging.verbosity";
    static final String JERSEY_LOGGING_LEVEL = "jersey.config.logging.logger.level";
    protected final Collection<String> jerseyResourcesAndProvidersPackages;
    protected final Collection<String> jerseyResourcesAndProvidersClasses;
    protected final ImmutableMap.Builder<String, String> jerseyParams;

    public JerseyBaseServerModule(Map<String, ArrayList<Map.Entry<Class<? extends Filter>, Map<String, String>>>> filters, Map<String, ArrayList<Map.Entry<Class<? extends Filter>, Map<String, String>>>> filtersRegex, Map<String, Class<? extends HttpServlet>> servlets, Map<String, Class<? extends HttpServlet>> servletsRegex, Map<String, Class<? extends HttpServlet>> jaxrsServlets, Map<String, Class<? extends HttpServlet>> jaxrsServletsRegex, String jaxrsUriPattern, Collection<String> jerseyResourcesAndProvidersPackages, Collection<String> jerseyResourcesAndProvidersClasses, Map<String, String> jerseyParams) {
        super(filters, filtersRegex, servlets, servletsRegex, jaxrsServlets, jaxrsServletsRegex, jaxrsUriPattern);
        this.jerseyResourcesAndProvidersPackages = jerseyResourcesAndProvidersPackages;
        this.jerseyResourcesAndProvidersClasses = jerseyResourcesAndProvidersClasses;
        this.jerseyParams = new ImmutableMap.Builder();
        String jerseyLoggingVerbosity = (String)MoreObjects.firstNonNull((Object)Strings.emptyToNull((String)jerseyParams.remove(JERSEY_LOGGING_VERBOSITY)), (Object)"HEADERS_ONLY");
        String jerseyLoggingLevel = (String)MoreObjects.firstNonNull((Object)Strings.emptyToNull((String)jerseyParams.remove(JERSEY_LOGGING_LEVEL)), (Object)"INFO");
        this.jerseyParams.put((Object)JERSEY_LOGGING_VERBOSITY, (Object)jerseyLoggingVerbosity).put((Object)JERSEY_LOGGING_LEVEL, (Object)jerseyLoggingLevel);
        this.jerseyParams.putAll(jerseyParams);
    }

    @Override
    protected void configureResources() {
        for (Map.Entry entry : this.jaxrsServlets.entrySet()) {
            this.serve((String)entry.getKey(), new String[0]).with((Class)entry.getValue(), (Map)this.jerseyParams.build());
        }
        for (Map.Entry entry : this.jaxrsServletsRegex.entrySet()) {
            this.serveRegex((String)entry.getKey(), new String[0]).with((Class)entry.getValue(), (Map)this.jerseyParams.build());
        }
        if (!this.jerseyResourcesAndProvidersPackages.isEmpty()) {
            this.jerseyParams.put((Object)"jersey.config.server.provider.packages", (Object)joiner.join(this.jerseyResourcesAndProvidersPackages));
            this.jerseyParams.put((Object)"jersey.config.server.provider.classnames", (Object)joiner.join(this.jerseyResourcesAndProvidersClasses));
            this.serveJaxrsResources();
        }
    }

    protected void serveJaxrsResources() {
        this.bind(GuiceServletContainer.class).asEagerSingleton();
        this.serveRegex(this.jaxrsUriPattern, new String[0]).with(GuiceServletContainer.class, (Map)this.jerseyParams.build());
    }

    @VisibleForTesting
    ImmutableMap.Builder<String, String> getJerseyParams() {
        return this.jerseyParams;
    }
}

