/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.http.HttpServlet;
import org.killbill.commons.skeleton.modules.BaseServerModule;
import org.killbill.commons.skeleton.modules.GuiceServletContainer;
import org.killbill.commons.utils.Joiner;
import org.killbill.commons.utils.Strings;
import org.killbill.commons.utils.annotation.VisibleForTesting;

public class JerseyBaseServerModule
extends BaseServerModule {
    private static final Joiner joiner = Joiner.on((String)";");
    @VisibleForTesting
    static final String JERSEY_LOGGING_VERBOSITY = "jersey.config.logging.verbosity";
    static final String JERSEY_LOGGING_LEVEL = "jersey.config.logging.logger.level";
    protected final Collection<String> jerseyResourcesAndProvidersPackages;
    protected final Collection<String> jerseyResourcesAndProvidersClasses;
    protected final Map<String, String> jerseyParams;

    public JerseyBaseServerModule(Map<String, ArrayList<Map.Entry<Class<? extends Filter>, Map<String, String>>>> filters, Map<String, ArrayList<Map.Entry<Class<? extends Filter>, Map<String, String>>>> filtersRegex, Map<String, Class<? extends HttpServlet>> servlets, Map<String, Class<? extends HttpServlet>> servletsRegex, Map<String, Class<? extends HttpServlet>> jaxrsServlets, Map<String, Class<? extends HttpServlet>> jaxrsServletsRegex, String jaxrsUriPattern, Collection<String> jerseyResourcesAndProvidersPackages, Collection<String> jerseyResourcesAndProvidersClasses, Map<String, String> jerseyParams) {
        super(filters, filtersRegex, servlets, servletsRegex, jaxrsServlets, jaxrsServletsRegex, jaxrsUriPattern);
        this.jerseyResourcesAndProvidersPackages = new ArrayList<String>(jerseyResourcesAndProvidersPackages);
        this.jerseyResourcesAndProvidersClasses = new ArrayList<String>(jerseyResourcesAndProvidersClasses);
        this.jerseyParams = new HashMap<String, String>();
        String jerseyLoggingVerbosity = Objects.requireNonNullElse(Strings.emptyToNull((String)jerseyParams.remove(JERSEY_LOGGING_VERBOSITY)), "HEADERS_ONLY");
        String jerseyLoggingLevel = Objects.requireNonNullElse(Strings.emptyToNull((String)jerseyParams.remove(JERSEY_LOGGING_LEVEL)), "INFO");
        this.jerseyParams.put(JERSEY_LOGGING_VERBOSITY, jerseyLoggingVerbosity);
        this.jerseyParams.put(JERSEY_LOGGING_LEVEL, jerseyLoggingLevel);
        this.jerseyParams.putAll(jerseyParams);
    }

    @Override
    protected void configureResources() {
        for (Map.Entry entry : this.jaxrsServlets.entrySet()) {
            this.serve((String)entry.getKey(), new String[0]).with((Class)entry.getValue(), this.jerseyParams);
        }
        for (Map.Entry entry : this.jaxrsServletsRegex.entrySet()) {
            this.serveRegex((String)entry.getKey(), new String[0]).with((Class)entry.getValue(), this.jerseyParams);
        }
        if (!this.jerseyResourcesAndProvidersPackages.isEmpty()) {
            this.jerseyParams.put("jersey.config.server.provider.packages", joiner.join(this.jerseyResourcesAndProvidersPackages));
            this.jerseyParams.put("jersey.config.server.provider.classnames", joiner.join(this.jerseyResourcesAndProvidersClasses));
            this.serveJaxrsResources();
        }
    }

    protected void serveJaxrsResources() {
        this.bind(GuiceServletContainer.class).asEagerSingleton();
        this.serveRegex(this.jaxrsUriPattern, new String[0]).with(GuiceServletContainer.class, this.jerseyParams);
    }

    @VisibleForTesting
    Map<String, String> getJerseyParams() {
        return this.jerseyParams;
    }
}

