/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.modules;

import com.google.inject.AbstractModule;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;
import org.skife.config.SimplePropertyConfigSource;

public class ConfigModule
extends AbstractModule {
    private final ConfigSource configSource;
    private final Iterable<Class> configs;

    public ConfigModule() {
        this(System.getProperties());
    }

    public ConfigModule(Properties properties) {
        this(Collections.emptyList(), (ConfigSource)new SimplePropertyConfigSource(properties));
    }

    public ConfigModule(Class config) {
        this(List.of(config));
    }

    public ConfigModule(Class ... configs) {
        this(List.of(configs));
    }

    public ConfigModule(Iterable<Class> configs) {
        this(configs, (ConfigSource)new SimplePropertyConfigSource(System.getProperties()));
    }

    public ConfigModule(Iterable<Class> configs, ConfigSource configSource) {
        this.configs = configs;
        this.configSource = configSource;
    }

    protected void configure() {
        for (Class config : this.configs) {
            this.bind(config).toInstance(new ConfigurationObjectFactory(this.configSource).build(config));
        }
    }
}

