/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.modules;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Singleton;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import org.aopalliance.intercept.ConstructorInterceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.InterceptionService;
import org.glassfish.jersey.spi.ExceptionMappers;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.commons.metrics.api.annotation.TimedResource;
import org.killbill.commons.skeleton.metrics.TimedResourceInterceptor;

@Singleton
public class TimedInterceptionService
implements InterceptionService {
    private final Set<String> resourcePackages;
    private final ExceptionMappers exceptionMappers;
    private final MetricRegistry metricRegistry;

    public TimedInterceptionService(Set<String> resourcePackage, ExceptionMappers exceptionMappers, MetricRegistry metricRegistry) {
        this.resourcePackages = new HashSet<String>(resourcePackage);
        this.exceptionMappers = exceptionMappers;
        this.metricRegistry = metricRegistry;
    }

    public Filter getDescriptorFilter() {
        return new Filter(){

            public boolean matches(Descriptor d) {
                String clazz = d.getImplementation();
                for (String resourcePackage : TimedInterceptionService.this.resourcePackages) {
                    if (!clazz.startsWith(resourcePackage)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public List<MethodInterceptor> getMethodInterceptors(Method method) {
        TimedResource annotation = method.getAnnotation(TimedResource.class);
        if (annotation == null) {
            return null;
        }
        Path pathAnnotation = method.getDeclaringClass().getAnnotation(Path.class);
        if (pathAnnotation == null) {
            return null;
        }
        String resourcePath = pathAnnotation.value();
        HttpMethod httpMethod = this.resourceHttpMethod(method);
        if (httpMethod == null) {
            return null;
        }
        String metricName = !annotation.name().trim().isEmpty() ? annotation.name() : method.getName();
        TimedResourceInterceptor timedResourceInterceptor = new TimedResourceInterceptor(this.exceptionMappers, this.metricRegistry, resourcePath, metricName, httpMethod.value());
        return List.of(timedResourceInterceptor);
    }

    private HttpMethod resourceHttpMethod(Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            HttpMethod httpMethod = annotation.annotationType().getAnnotation(HttpMethod.class);
            if (httpMethod == null) continue;
            return httpMethod;
        }
        return null;
    }

    public List<ConstructorInterceptor> getConstructorInterceptors(Constructor<?> constructor) {
        return null;
    }
}

