/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.listeners;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.util.List;
import javax.servlet.ServletContextEvent;
import org.killbill.commons.utils.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceServletContextListener
extends com.google.inject.servlet.GuiceServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(GuiceServletContextListener.class);
    protected Iterable<? extends Module> guiceModules = null;

    public void contextInitialized(ServletContextEvent event) {
        if (this.guiceModules == null) {
            this.guiceModules = List.of(this.initializeGuiceModuleFromWebXML(event));
        }
        super.contextInitialized(event);
    }

    private Module initializeGuiceModuleFromWebXML(ServletContextEvent event) {
        String moduleClassName = event.getServletContext().getInitParameter("guiceModuleClassName");
        if (Strings.isNullOrEmpty((String)moduleClassName)) {
            throw new IllegalStateException("Missing parameter for the base Guice module!");
        }
        try {
            Class<?> moduleClass = Class.forName(moduleClassName);
            if (!Module.class.isAssignableFrom(moduleClass)) {
                throw new IllegalStateException(String.format("%s exists but is not a Guice Module!", moduleClassName));
            }
            Module module = (Module)moduleClass.newInstance();
            log.info("Instantiated " + moduleClassName + " as the main guice module.");
            return module;
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException(cnfe);
        }
        catch (InstantiationException ie) {
            throw new IllegalStateException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException(iae);
        }
    }

    protected Injector getInjector() {
        if (this.guiceModules == null) {
            throw new IllegalStateException("Never found the Guice Module to use!");
        }
        return Guice.createInjector((Stage)Stage.PRODUCTION, this.guiceModules);
    }

    public Injector injector(ServletContextEvent event) {
        return (Injector)event.getServletContext().getAttribute(Injector.class.getName());
    }
}

