/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanServer;
import org.weakref.jmx.guice.ExportBinder;
import org.weakref.jmx.guice.MBeanModule;

public class JMXModule
extends AbstractModule {
    private final Iterable<Class<?>> beans;

    public JMXModule() {
        this(Collections.emptyList());
    }

    public JMXModule(Class<?> bean) {
        this(List.of(bean));
    }

    public JMXModule(Class<?> ... beans) {
        this(List.of(beans));
    }

    public JMXModule(Iterable<Class<?>> beans) {
        this.beans = beans;
    }

    protected void configure() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.binder().bind(MBeanServer.class).toInstance((Object)mBeanServer);
        this.install((Module)new MBeanModule());
        ExportBinder builder = ExportBinder.newExporter((Binder)this.binder());
        for (Class<?> beanClass : this.beans) {
            builder.export(beanClass).withGeneratedName();
        }
    }
}

