/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.metrics;

import java.util.concurrent.TimeUnit;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.killbill.commons.skeleton.metrics.TimedResourceMetric;

public class TimedResourceInterceptor
implements MethodInterceptor {
    private final TimedResourceMetric timer;

    public TimedResourceInterceptor(TimedResourceMetric timer) {
        this.timer = timer;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        long startTime = System.nanoTime();
        Integer status = null;
        try {
            Object result = invocation.proceed();
            if (result instanceof Response) {
                status = ((Response)result).getStatus();
            }
            Object object = result;
            return object;
        }
        catch (WebApplicationException ex) {
            status = ex.getResponse().getStatus();
            throw ex;
        }
        finally {
            this.timer.update(status, System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }
}

