/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.metrics;

import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.reflect.Method;
import java.util.concurrent.Future;
import org.aopalliance.intercept.MethodInterceptor;
import org.killbill.commons.skeleton.metrics.TimedResource;
import org.killbill.commons.skeleton.metrics.TimedResourceInterceptor;
import org.killbill.commons.skeleton.metrics.TimedResourceMetric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedResourceListener
implements TypeListener {
    private final SettableFuture<MetricRegistry> metricsRegistryFuture = SettableFuture.create();

    @Inject
    public void setMetricsRegistry(MetricRegistry metricsRegistry) {
        this.metricsRegistryFuture.set((Object)metricsRegistry);
    }

    public <T> void hear(TypeLiteral<T> literal, TypeEncounter<T> encounter) {
        for (Method method : literal.getRawType().getMethods()) {
            TimedResource annotation = method.getAnnotation(TimedResource.class);
            if (annotation == null) continue;
            String name = annotation.name().isEmpty() ? method.getName() : annotation.name();
            TimedResourceMetric timer = new TimedResourceMetric((Future<MetricRegistry>)this.metricsRegistryFuture, literal.getRawType(), name, annotation.defaultStatusCode());
            encounter.bindInterceptor(Matchers.only((Object)method), new MethodInterceptor[]{new TimedResourceInterceptor(timer)});
        }
    }
}

