/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedResourceMetric {
    private static final Logger log = LoggerFactory.getLogger(TimedResourceMetric.class);
    private final int defaultStatusCode;
    private final LoadingCache<Integer, Timer> metrics;

    public TimedResourceMetric(final Future<MetricRegistry> metricsRegistryFuture, final Class<?> klass, final String name, int defaultStatusCode) {
        this.defaultStatusCode = defaultStatusCode;
        this.metrics = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, Timer>(){

            public Timer load(Integer input) {
                try {
                    return ((MetricRegistry)metricsRegistryFuture.get(1L, TimeUnit.SECONDS)).timer(MetricRegistry.name((Class)klass, (String[])new String[]{name + "-" + input}));
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return null;
                }
                catch (TimeoutException ex) {
                    throw new IllegalStateException("Received requests during guice initialization", ex);
                }
                catch (ExecutionException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        });
    }

    public void update(Integer statusCode, long duration, TimeUnit unit) {
        try {
            ((Timer)this.metrics.get((Object)(statusCode == null ? this.defaultStatusCode : statusCode))).update(duration, unit);
        }
        catch (ExecutionException e) {
            log.warn("Error while updating time", (Throwable)e);
        }
    }
}

