/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.eventbus;

import java.lang.reflect.InvocationTargetException;
import org.killbill.commons.eventbus.CatchableSubscriberExceptionHandler;
import org.killbill.commons.eventbus.LoggingHandler;
import org.killbill.commons.eventbus.SubscriberExceptionContext;
import org.killbill.commons.eventbus.SubscriberExceptionHandler;

class DefaultCatchableSubscriberExceptionsHandler
implements CatchableSubscriberExceptionHandler {
    private final ThreadLocal<Exception> lastException = new ThreadLocal<Exception>(){};
    private final SubscriberExceptionHandler loggerHandler = LoggingHandler.INSTANCE;

    DefaultCatchableSubscriberExceptionsHandler() {
    }

    @Override
    public void handleException(Throwable exception, SubscriberExceptionContext context) {
        if (this.lastException.get() == null) {
            this.lastException.set(new InvocationTargetException(exception));
        }
        this.loggerHandler.handleException(exception, context);
    }

    @Override
    public Exception caughtException() {
        Exception exception = this.lastException.get();
        this.reset();
        return exception;
    }

    @Override
    public void reset() {
        this.lastException.set(null);
    }
}

