/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.eventbus;

import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.killbill.commons.eventbus.CatchableSubscriberExceptionHandler;
import org.killbill.commons.eventbus.DeadEvent;
import org.killbill.commons.eventbus.DefaultCatchableSubscriberExceptionsHandler;
import org.killbill.commons.eventbus.Dispatcher;
import org.killbill.commons.eventbus.EventBusException;
import org.killbill.commons.eventbus.Subscriber;
import org.killbill.commons.eventbus.SubscriberExceptionContext;
import org.killbill.commons.eventbus.SubscriberExceptionHandler;
import org.killbill.commons.eventbus.SubscriberRegistry;
import org.killbill.commons.utils.Preconditions;
import org.killbill.commons.utils.concurrent.DirectExecutor;

public class EventBus {
    private static final Logger logger = Logger.getLogger(EventBus.class.getName());
    private final String identifier;
    private final Executor executor;
    private final SubscriberExceptionHandler exceptionHandler;
    private final SubscriberRegistry subscribers = new SubscriberRegistry(this);
    private final Dispatcher dispatcher;

    public EventBus() {
        this("default");
    }

    public EventBus(String identifier) {
        this(identifier, DirectExecutor.INSTANCE, Dispatcher.immediate(), new DefaultCatchableSubscriberExceptionsHandler());
    }

    public EventBus(SubscriberExceptionHandler exceptionHandler) {
        this("default", DirectExecutor.INSTANCE, Dispatcher.immediate(), exceptionHandler);
    }

    public EventBus(String identifier, Executor executor, Dispatcher dispatcher, SubscriberExceptionHandler exceptionHandler) {
        this.identifier = Preconditions.checkNotNull(identifier);
        this.executor = Preconditions.checkNotNull(executor);
        this.dispatcher = Preconditions.checkNotNull(dispatcher);
        this.exceptionHandler = Preconditions.checkNotNull(exceptionHandler);
    }

    public final String identifier() {
        return this.identifier;
    }

    final Executor executor() {
        return this.executor;
    }

    void handleSubscriberException(Throwable e, SubscriberExceptionContext context) {
        Preconditions.checkNotNull(e);
        Preconditions.checkNotNull(context);
        try {
            this.exceptionHandler.handleException(e, context);
        }
        catch (Throwable e2) {
            logger.log(Level.SEVERE, String.format(Locale.ROOT, "Exception %s thrown while handling exception: %s", e2, e), e2);
        }
    }

    public void register(Object object) {
        this.subscribers.register(object);
    }

    public void unregister(Object object) {
        this.subscribers.unregister(object);
    }

    public void post(Object event) {
        Iterator<Subscriber> eventSubscribers = this.subscribers.getSubscribers(event);
        if (eventSubscribers.hasNext()) {
            this.dispatcher.dispatch(event, eventSubscribers);
        } else if (!(event instanceof DeadEvent)) {
            this.post(new DeadEvent(this, event));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postWithException(Object event) throws EventBusException {
        Preconditions.checkState(this.exceptionHandler instanceof CatchableSubscriberExceptionHandler, "exceptionHandler should be instance of CatchableSubscriberExceptionHandler");
        Preconditions.checkState(this.executor instanceof DirectExecutor, "executor should be instance of DirectExecutor");
        Preconditions.checkState(this.dispatcher instanceof Dispatcher.ImmediateDispatcher, "dispatcher should be instance of ImmediateDispatcher");
        CatchableSubscriberExceptionHandler catchableExceptionHandler = (CatchableSubscriberExceptionHandler)this.exceptionHandler;
        Iterator<Subscriber> eventSubscribers = this.subscribers.getSubscribers(event);
        if (eventSubscribers.hasNext()) {
            Exception subscriberException;
            catchableExceptionHandler.reset();
            RuntimeException guavaException = null;
            try {
                this.dispatcher.dispatch(event, eventSubscribers);
            }
            catch (RuntimeException e) {
                guavaException = e;
            }
            finally {
                subscriberException = catchableExceptionHandler.caughtException();
            }
            if (guavaException != null) {
                throw guavaException;
            }
            if (subscriberException != null) {
                throw new EventBusException(subscriberException);
            }
        } else if (!(event instanceof DeadEvent)) {
            this.post(new DeadEvent(this, event));
        }
    }

    public String toString() {
        return "EventBus {identifier='" + this.identifier + "'}";
    }
}

