/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.utils.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.killbill.commons.utils.Preconditions;
import org.killbill.commons.utils.annotation.VisibleForTesting;
import org.killbill.commons.utils.cache.Cache;
import org.killbill.commons.utils.cache.TimedValue;

public class DefaultCache<K, V>
implements Cache<K, V> {
    public static final long NO_TIMEOUT = 0L;
    @VisibleForTesting
    final Map<K, TimedValue<V>> map;
    private final long timeoutMillis;
    private final Function<K, V> cacheLoader;

    public DefaultCache(int maxSize) {
        this(maxSize, 0L, DefaultCache.noCacheLoader());
    }

    public DefaultCache(Function<K, V> cacheLoader) {
        this(Integer.MAX_VALUE, 0L, cacheLoader);
    }

    public DefaultCache(final int maxSize, long timeoutInSecond, Function<K, V> cacheLoader) {
        Preconditions.checkArgument(maxSize > 0, "cache maxSize should > 0", new Object[0]);
        Preconditions.checkArgument(timeoutInSecond >= 0L, "cache timeoutInSecond should >= 0", new Object[0]);
        this.timeoutMillis = timeoutInSecond * 1000L;
        this.cacheLoader = Preconditions.checkNotNull(cacheLoader, "cacheLoader is null. Use DefaultCache#noCacheLoader() to create a cache without loader");
        this.map = new LinkedHashMap<K, TimedValue<V>>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, TimedValue<V>> eldest) {
                return this.size() > maxSize;
            }
        };
    }

    public static <K1, V1> Function<K1, V1> noCacheLoader() {
        return k1 -> null;
    }

    protected boolean isTimeoutEnabled() {
        return this.timeoutMillis > 0L;
    }

    protected boolean isCacheLoaderExist() {
        return !DefaultCache.noCacheLoader().equals(this.cacheLoader);
    }

    protected void evictExpireEntry(K key) {
        TimedValue<V> value;
        if (this.isTimeoutEnabled() && (value = this.map.get(key)) != null && value.isTimeout()) {
            this.invalidate(key);
        }
    }

    @Override
    public V get(K key) {
        Preconditions.checkNotNull(key, "Cannot #get() cache with key = null");
        this.evictExpireEntry(key);
        TimedValue<V> timedValue = this.map.get(key);
        if (timedValue != null) {
            return timedValue.getValue();
        }
        if (this.isCacheLoaderExist()) {
            V value = this.cacheLoader.apply(key);
            if (value != null) {
                this.put(key, value);
            }
            return value;
        }
        return null;
    }

    @Override
    public V getOrLoad(K key, Function<K, V> loader) {
        Preconditions.checkNotNull(loader, "loader parameter in #getOrLoad() is null");
        V value = this.get(key);
        return value == null ? loader.apply(key) : value;
    }

    @Override
    public void put(K key, V value) {
        Preconditions.checkNotNull(key, "key in #put() is null");
        Preconditions.checkNotNull(value, "value in #put() is null");
        this.map.put(key, new TimedValue<V>(this.timeoutMillis, value));
    }

    @Override
    public void invalidate(K key) {
        Preconditions.checkNotNull(key, "Cannot invalidate. Cache with null key is not allowed");
        this.map.remove(key);
    }
}

