/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.utils.io;

import java.io.IOException;
import java.io.Reader;
import org.killbill.commons.utils.Preconditions;

public final class CharStreams {
    private static final int DEFAULT_BUF_SIZE = 2048;

    public static String toString(Readable r) throws IOException {
        return CharStreams.toStringBuilder(r).toString();
    }

    private static StringBuilder toStringBuilder(Readable r) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (!(r instanceof Reader)) {
            throw new RuntimeException("IOUtils#toStringBuilder() parameter should be instance of java.io.Reader");
        }
        CharStreams.copyReaderToBuilder((Reader)r, sb);
        return sb;
    }

    static long copyReaderToBuilder(Reader from, StringBuilder to) throws IOException {
        int nRead;
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        char[] buf = new char[2048];
        long total = 0L;
        while ((nRead = from.read(buf)) != -1) {
            to.append(buf, 0, nRead);
            total += (long)nRead;
        }
        return total;
    }
}

