/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.utils.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.killbill.commons.utils.Preconditions;
import org.killbill.commons.utils.collect.Iterators;

public final class Iterables {
    public static <T> T getFirst(Iterable<? extends T> iterable, T defaultValue) {
        return Iterators.getNext(iterable.iterator(), defaultValue);
    }

    public static <T> T getLast(Iterable<T> iterable) {
        if (iterable instanceof List) {
            List list = (List)iterable;
            if (list.isEmpty()) {
                throw new NoSuchElementException("Cannot Iterables#getLast(iterable) on empty list");
            }
            return (T)list.get(list.size() - 1);
        }
        return Iterators.getLast(iterable.iterator());
    }

    public static <T> T getLast(Iterable<? extends T> iterable, T defaultValue) {
        if (iterable instanceof Collection) {
            Collection c = (Collection)iterable;
            if (c.isEmpty()) {
                return defaultValue;
            }
            if (iterable instanceof List) {
                List list = (List)iterable;
                return (T)list.get(list.size() - 1);
            }
        }
        return Iterators.getLast(iterable.iterator(), defaultValue);
    }

    public static <T> Iterable<T> concat(Iterable<T> ... iterables) {
        Preconditions.checkNotNull(iterables);
        ArrayList result = new ArrayList();
        for (Iterable<Object> iterable : iterables) {
            Preconditions.checkNotNull(iterable, "One of iterable in Iterables#concat() is null");
            iterable.forEach(result::add);
        }
        return result;
    }

    public static <T> Set<T> toUnmodifiableSet(Iterable<? extends T> iterable) {
        return Iterables.toStream(iterable).collect(Collectors.toUnmodifiableSet());
    }

    public static <T> List<T> toUnmodifiableList(Iterable<? extends T> iterable) {
        return Iterables.toStream(iterable).collect(Collectors.toUnmodifiableList());
    }

    public static <T> List<T> toList(Iterable<? extends T> iterable) {
        return Iterables.toStream(iterable).collect(Collectors.toList());
    }

    public static <E> Stream<E> toStream(Iterable<E> iterable) {
        Preconditions.checkNotNull(iterable);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return !iterable.iterator().hasNext();
    }

    public static int size(Iterable<?> iterable) {
        return iterable instanceof Collection ? ((Collection)iterable).size() : Iterators.size(iterable.iterator());
    }

    public static boolean contains(Iterable<?> iterable, Object element) {
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            return Iterables.safeContains(collection, element);
        }
        return Iterators.contains(iterable.iterator(), element);
    }

    private static boolean safeContains(Collection<?> collection, Object object) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkNotNull(object);
        try {
            return collection.contains(object);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public static <T> T getOnlyElement(Iterable<T> iterable) {
        return Iterators.getOnlyElement(iterable.iterator());
    }
}

