/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.utils.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Queue;
import org.killbill.commons.utils.Preconditions;
import org.killbill.commons.utils.math.IntMath;

public final class ByteStreams {
    private static final int BUFFER_SIZE = 8192;
    private static final int MAX_ARRAY_LEN = 0x7FFFFFF7;
    private static final int TO_BYTE_ARRAY_DEQUE_SIZE = 20;

    public static byte[] toByteArray(InputStream in) throws IOException {
        Preconditions.checkNotNull(in);
        return ByteStreams.toByteArrayInternal(in, new ArrayDeque<byte[]>(20), 0);
    }

    private static byte[] toByteArrayInternal(InputStream in, Queue<byte[]> bufs, int totalLen) throws IOException {
        int bufSize = 8192;
        while (totalLen < 0x7FFFFFF7) {
            byte[] buf = new byte[Math.min(bufSize, 0x7FFFFFF7 - totalLen)];
            bufs.add(buf);
            int off = 0;
            while (off < buf.length) {
                int r = in.read(buf, off, buf.length - off);
                if (r == -1) {
                    return ByteStreams.combineBuffers(bufs, totalLen);
                }
                off += r;
                totalLen += r;
            }
            bufSize = IntMath.saturatedMultiply(bufSize, 2);
        }
        if (in.read() == -1) {
            return ByteStreams.combineBuffers(bufs, 0x7FFFFFF7);
        }
        throw new OutOfMemoryError("input is too large to fit in a byte array");
    }

    private static byte[] combineBuffers(Queue<byte[]> bufs, int totalLen) {
        int bytesToCopy;
        byte[] result = new byte[totalLen];
        for (int remaining = totalLen; remaining > 0; remaining -= bytesToCopy) {
            byte[] buf = bufs.remove();
            bytesToCopy = Math.min(remaining, buf.length);
            int resultOffset = totalLen - remaining;
            System.arraycopy(buf, 0, result, resultOffset, bytesToCopy);
        }
        return result;
    }
}

