/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.xmlloader;

import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Scanner;

public class UriAccessor {
    private static final String URI_SCHEME_FOR_ARCHIVE_FILE = "jar:file";
    private static final String URI_SCHEME_FOR_CLASSPATH = "jar";
    private static final String URI_SCHEME_FOR_FILE = "file";

    public static URL toURL(String uri) throws IOException, URISyntaxException {
        return UriAccessor.toURL(new URI(uri));
    }

    public static URL toURL(URI inputURI) throws IOException, URISyntaxException {
        String scheme = inputURI.getScheme();
        URI uri = scheme == null ? new URI(Resources.getResource((String)inputURI.toString()).toExternalForm()) : (scheme.equals(URI_SCHEME_FOR_FILE) && !inputURI.getSchemeSpecificPart().startsWith("/") ? new File(inputURI.getSchemeSpecificPart()).toURI() : inputURI);
        return uri.toURL();
    }

    public static InputStream accessUri(String uri) throws IOException, URISyntaxException {
        return UriAccessor.accessUri(new URI(uri));
    }

    public static InputStream accessUri(URI uri) throws IOException, URISyntaxException {
        String scheme = uri.getScheme();
        if (URI_SCHEME_FOR_CLASSPATH.equals(scheme)) {
            if (uri.toString().startsWith(URI_SCHEME_FOR_ARCHIVE_FILE)) {
                return UriAccessor.getInputStreamFromJarFile(uri);
            }
            return UriAccessor.class.getResourceAsStream(uri.getPath());
        }
        URL url = UriAccessor.toURL(uri);
        return url.openConnection().getInputStream();
    }

    private static InputStream getInputStreamFromJarFile(URI uri) throws IOException {
        URL url = uri.toURL();
        JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
        return jarURLConnection.getJarFile().getInputStream(jarURLConnection.getJarEntry());
    }

    public static String accessUriAsString(String uri) throws IOException, URISyntaxException {
        return UriAccessor.accessUriAsString(new URI(uri));
    }

    public static String accessUriAsString(URI uri) throws IOException, URISyntaxException {
        InputStream stream = UriAccessor.accessUri(uri);
        return new Scanner(stream).useDelimiter("\\A").next();
    }
}

