/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.xmlloader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class XMLSchemaGenerator {
    private static final int MAX_SCHEMA_SIZE_IN_BYTES = 100000;

    public static void main(String[] args) throws IOException, TransformerException, JAXBException, ClassNotFoundException {
        if (args.length != 2) {
            XMLSchemaGenerator.printUsage();
            System.exit(0);
        }
        Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(args[1]);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        String xsdFileName = "Schema.xsd";
        if (args.length != 0) {
            xsdFileName = args[0] + "/" + xsdFileName;
        }
        FileOutputStream s = new FileOutputStream(xsdFileName);
        XMLSchemaGenerator.pojoToXSD(context, s);
    }

    private static void printUsage() {
        System.out.println(XMLSchemaGenerator.class.getName() + " <file> <class1>");
    }

    public static String xmlSchemaAsString(Class<?> clazz) throws IOException, TransformerException, JAXBException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(100000);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        XMLSchemaGenerator.pojoToXSD(context, output);
        return new String(output.toByteArray());
    }

    public static InputStream xmlSchema(Class<?> clazz) throws IOException, TransformerException, JAXBException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(100000);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        XMLSchemaGenerator.pojoToXSD(context, output);
        return new ByteArrayInputStream(output.toByteArray());
    }

    public static void pojoToXSD(JAXBContext context, OutputStream out) throws IOException, TransformerException {
        final ArrayList results = new ArrayList();
        context.generateSchema(new SchemaOutputResolver(){

            public Result createOutput(String ns, String file) throws IOException {
                DOMResult result = new DOMResult();
                result.setSystemId(file);
                results.add(result);
                return result;
            }
        });
        DOMResult domResult = (DOMResult)results.get(0);
        Document doc = (Document)domResult.getNode();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(out);
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
    }
}

