/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.xmlloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.killbill.billing.catalog.api.InvalidConfigException;
import org.killbill.xmlloader.UriAccessor;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationErrors;
import org.killbill.xmlloader.ValidationException;
import org.killbill.xmlloader.XMLSchemaGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLLoader {
    public static Logger log = LoggerFactory.getLogger(XMLLoader.class);

    public static <T extends ValidatingConfig<T>> T getObjectFromString(String uri, Class<T> objectType) throws Exception {
        if (uri == null) {
            return null;
        }
        log.info("Initializing an object of class " + objectType.getName() + " from xml file at: " + uri);
        return XMLLoader.getObjectFromStream(new URI(uri), UriAccessor.accessUri(uri), objectType);
    }

    public static <T extends ValidatingConfig<T>> T getObjectFromUri(URI uri, Class<T> objectType) throws Exception {
        if (uri == null) {
            return null;
        }
        log.info("Initializing an object of class " + objectType.getName() + " from xml file at: " + uri);
        return XMLLoader.getObjectFromStream(uri, UriAccessor.accessUri(uri), objectType);
    }

    public static <T extends ValidatingConfig<T>> T getObjectFromStream(URI uri, InputStream stream, Class<T> clazz) throws SAXException, InvalidConfigException, JAXBException, IOException, TransformerException, ValidationException {
        if (stream == null) {
            return null;
        }
        Object o = XMLLoader.unmarshaller(clazz).unmarshal(stream);
        if (clazz.isInstance(o)) {
            ValidatingConfig castObject = (ValidatingConfig)o;
            try {
                XMLLoader.validate(uri, castObject);
            }
            catch (ValidationException e) {
                e.getErrors().log(log);
                throw e;
            }
            return (T)castObject;
        }
        return null;
    }

    public static <T> T getObjectFromStreamNoValidation(InputStream stream, Class<T> clazz) throws SAXException, InvalidConfigException, JAXBException, IOException, TransformerException {
        Object o = XMLLoader.unmarshaller(clazz).unmarshal(stream);
        if (clazz.isInstance(o)) {
            Object castObject = o;
            return (T)castObject;
        }
        return null;
    }

    public static <T extends ValidatingConfig<T>> void validate(URI uri, T c) throws ValidationException {
        c.initialize(c, uri);
        ValidationErrors errs = c.validate(c, new ValidationErrors());
        log.info("Errors: " + errs.size() + " for " + uri);
        if (errs.size() > 0) {
            throw new ValidationException(errs);
        }
    }

    public static Unmarshaller unmarshaller(Class<?> clazz) throws JAXBException, SAXException, IOException, TransformerException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Unmarshaller um = context.createUnmarshaller();
        Schema schema = factory.newSchema(new StreamSource(XMLSchemaGenerator.xmlSchema(clazz)));
        um.setSchema(schema);
        return um;
    }
}

