/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.net.InetAddresses;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.util.NodeType;

public final class IPV6FormatSpecifier
extends FormatSpecifier {
    private static final FormatSpecifier instance = new IPV6FormatSpecifier();
    private static final int IPV6_LENGTH = 16;

    private IPV6FormatSpecifier() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatSpecifier getInstance() {
        return instance;
    }

    @Override
    void checkValue(ValidationReport report, JsonNode value) {
        String ipaddr = value.textValue();
        if (!InetAddresses.isInetAddress((String)ipaddr)) {
            report.addMessage("string is not a valid IPv6 address");
            return;
        }
        if (InetAddresses.forString((String)ipaddr).getAddress().length != 16) {
            report.addMessage("string is not a valid IPv6 address");
        }
    }
}

